/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.room;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.entity.HistoricalEntity;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;

@Entity
@NamedQueries(value={@NamedQuery(name="getInvitationbyId", query="SELECT i FROM Invitation i WHERE i.deleted = false AND i.id = :id"), @NamedQuery(name="getInvitationByHashCode", query="SELECT i FROM Invitation i where i.hash LIKE :hashCode AND i.deleted = false"), @NamedQuery(name="getInvitationByAppointment", query="SELECT i FROM Invitation i WHERE i.appointment.id = :appointmentId")})
@Table(name="invitation", indexes={@Index(name="inv_hash_idx", columnList="hash", unique=true)})
public class Invitation
extends HistoricalEntity
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="invited_by", nullable=true)
    @ForeignKey(enabled=true)
    private User invitedBy;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="room_id", nullable=true)
    @ForeignKey(enabled=true)
    private Room room;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="recording_id", nullable=true)
    @ForeignKey(enabled=true)
    private Recording recording;
    @Column(name="hash")
    private String hash;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="invitee_id", nullable=true)
    @ForeignKey(enabled=true)
    private User invitee;
    @Column(name="password_protected", nullable=false)
    private boolean passwordProtected;
    @Column(name="password", length=1024)
    private String password;
    @Column(name="valid")
    @Enumerated(value=EnumType.STRING)
    private Valid valid = Valid.PERIOD;
    @Column(name="valid_from")
    private Date validFrom;
    @Column(name="valid_to")
    private Date validTo;
    @Column(name="was_used", nullable=false)
    private boolean used;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="appointment_id", nullable=true)
    @ForeignKey(enabled=true)
    private Appointment appointment;
    @Transient
    private boolean allowEntry = true;
    private static int pcInheritedFieldCount = HistoricalEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public Invitation() {
    }

    public Invitation(Invitation i) {
        this.id = i.id;
        this.invitedBy = i.invitedBy;
        this.setInserted(i.getInserted());
        this.setUpdated(i.getUpdated());
        this.setDeleted(i.isDeleted());
        this.room = i.room;
        this.recording = i.recording;
        this.hash = i.hash;
        this.invitee = i.invitee;
        this.passwordProtected = i.passwordProtected;
        this.password = i.password;
        this.valid = i.valid;
        this.validFrom = i.validFrom;
        this.validTo = i.validTo;
        this.used = i.used;
        this.appointment = i.appointment;
    }

    @Override
    public Long getId() {
        return Invitation.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        Invitation.pcSetid(this, id);
    }

    public Room getRoom() {
        return Invitation.pcGetroom(this);
    }

    public void setRoom(Room room) {
        Invitation.pcSetroom(this, room);
    }

    public Recording getRecording() {
        return Invitation.pcGetrecording(this);
    }

    public void setRecording(Recording recording) {
        Invitation.pcSetrecording(this, recording);
    }

    public User getInvitedBy() {
        return Invitation.pcGetinvitedBy(this);
    }

    public void setInvitedBy(User invitedBy) {
        Invitation.pcSetinvitedBy(this, invitedBy);
    }

    public String getHash() {
        return Invitation.pcGethash(this);
    }

    public void setHash(String hash) {
        Invitation.pcSethash(this, hash);
    }

    public User getInvitee() {
        return Invitation.pcGetinvitee(this);
    }

    public void setInvitee(User invitee) {
        Invitation.pcSetinvitee(this, invitee);
    }

    public boolean isPasswordProtected() {
        return Invitation.pcGetpasswordProtected(this);
    }

    public void setPasswordProtected(boolean passwordProtected) {
        Invitation.pcSetpasswordProtected(this, passwordProtected);
    }

    public String getPassword() {
        return Invitation.pcGetpassword(this);
    }

    public void setPassword(String password) {
        Invitation.pcSetpassword(this, password);
    }

    public Date getValidFrom() {
        return Invitation.pcGetvalidFrom(this);
    }

    public void setValidFrom(Date validFrom) {
        Invitation.pcSetvalidFrom(this, validFrom);
    }

    public Date getValidTo() {
        return Invitation.pcGetvalidTo(this);
    }

    public void setValidTo(Date validTo) {
        Invitation.pcSetvalidTo(this, validTo);
    }

    public boolean isUsed() {
        return Invitation.pcGetused(this);
    }

    public void setUsed(boolean used) {
        Invitation.pcSetused(this, used);
    }

    public Appointment getAppointment() {
        return Invitation.pcGetappointment(this);
    }

    public void setAppointment(Appointment appointment) {
        Invitation.pcSetappointment(this, appointment);
    }

    public Valid getValid() {
        return Invitation.pcGetvalid(this);
    }

    public void setValid(Valid valid) {
        Invitation.pcSetvalid(this, valid);
    }

    public boolean isAllowEntry() {
        return this.allowEntry;
    }

    public void setAllowEntry(boolean allowEntry) {
        this.allowEntry = allowEntry;
    }

    public boolean isOwner(Long userId) {
        return Invitation.pcGetinvitedBy(this) != null && Invitation.pcGetinvitedBy(this).getId().equals(userId);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcPCSuperclass = HistoricalEntity.class;
        pcFieldNames = new String[]{"appointment", "hash", "id", "invitedBy", "invitee", "password", "passwordProtected", "recording", "room", "used", "valid", "validFrom", "validTo"};
        pcFieldTypes = new Class[]{Appointment.class, String.class, Long.class, User.class, User.class, String.class, Boolean.TYPE, Recording.class, Room.class, Boolean.TYPE, Valid.class, Date.class, Date.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(Invitation.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Invitation", (PersistenceCapable)new Invitation());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.appointment = null;
        this.hash = null;
        this.id = null;
        this.invitedBy = null;
        this.invitee = null;
        this.password = null;
        this.passwordProtected = false;
        this.recording = null;
        this.room = null;
        this.used = false;
        this.valid = null;
        this.validFrom = null;
        this.validTo = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Invitation invitation = new Invitation();
        if (bl) {
            invitation.pcClearFields();
        }
        invitation.pcStateManager = stateManager;
        invitation.pcCopyKeyFieldsFromObjectId(object);
        return invitation;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Invitation invitation = new Invitation();
        if (bl) {
            invitation.pcClearFields();
        }
        invitation.pcStateManager = stateManager;
        return invitation;
    }

    protected static int pcGetManagedFieldCount() {
        return 13 + HistoricalEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.appointment = (Appointment)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.hash = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.invitedBy = (User)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.invitee = (User)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.passwordProtected = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.recording = (Recording)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.room = (Room)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.used = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.valid = (Valid)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 11: {
                this.validFrom = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.validTo = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.appointment);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.hash);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.invitedBy);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.invitee);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.passwordProtected);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.recording);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.room);
                return;
            }
            case 9: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.used);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.valid);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.validFrom);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.validTo);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(Invitation invitation, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(invitation, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.appointment = invitation.appointment;
                return;
            }
            case 1: {
                this.hash = invitation.hash;
                return;
            }
            case 2: {
                this.id = invitation.id;
                return;
            }
            case 3: {
                this.invitedBy = invitation.invitedBy;
                return;
            }
            case 4: {
                this.invitee = invitation.invitee;
                return;
            }
            case 5: {
                this.password = invitation.password;
                return;
            }
            case 6: {
                this.passwordProtected = invitation.passwordProtected;
                return;
            }
            case 7: {
                this.recording = invitation.recording;
                return;
            }
            case 8: {
                this.room = invitation.room;
                return;
            }
            case 9: {
                this.used = invitation.used;
                return;
            }
            case 10: {
                this.valid = invitation.valid;
                return;
            }
            case 11: {
                this.validFrom = invitation.validFrom;
                return;
            }
            case 12: {
                this.validTo = invitation.validTo;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Invitation invitation = (Invitation)object;
        if (invitation.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(invitation, nArray[i]);
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(2 + pcInheritedFieldCount, (Object)longId.getId());
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(Invitation.class, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        return new LongId(Invitation.class, this.id);
    }

    private static final Appointment pcGetappointment(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.appointment;
        }
        int n = pcInheritedFieldCount + 0;
        invitation.pcStateManager.accessingField(n);
        return invitation.appointment;
    }

    private static final void pcSetappointment(Invitation invitation, Appointment appointment) {
        if (invitation.pcStateManager == null) {
            invitation.appointment = appointment;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 0, (Object)invitation.appointment, (Object)appointment, 0);
    }

    private static final String pcGethash(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.hash;
        }
        int n = pcInheritedFieldCount + 1;
        invitation.pcStateManager.accessingField(n);
        return invitation.hash;
    }

    private static final void pcSethash(Invitation invitation, String string) {
        if (invitation.pcStateManager == null) {
            invitation.hash = string;
            return;
        }
        invitation.pcStateManager.settingStringField((PersistenceCapable)invitation, pcInheritedFieldCount + 1, invitation.hash, string, 0);
    }

    private static final Long pcGetid(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.id;
        }
        int n = pcInheritedFieldCount + 2;
        invitation.pcStateManager.accessingField(n);
        return invitation.id;
    }

    private static final void pcSetid(Invitation invitation, Long l) {
        if (invitation.pcStateManager == null) {
            invitation.id = l;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 2, (Object)invitation.id, (Object)l, 0);
    }

    private static final User pcGetinvitedBy(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.invitedBy;
        }
        int n = pcInheritedFieldCount + 3;
        invitation.pcStateManager.accessingField(n);
        return invitation.invitedBy;
    }

    private static final void pcSetinvitedBy(Invitation invitation, User user) {
        if (invitation.pcStateManager == null) {
            invitation.invitedBy = user;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 3, (Object)invitation.invitedBy, (Object)user, 0);
    }

    private static final User pcGetinvitee(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.invitee;
        }
        int n = pcInheritedFieldCount + 4;
        invitation.pcStateManager.accessingField(n);
        return invitation.invitee;
    }

    private static final void pcSetinvitee(Invitation invitation, User user) {
        if (invitation.pcStateManager == null) {
            invitation.invitee = user;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 4, (Object)invitation.invitee, (Object)user, 0);
    }

    private static final String pcGetpassword(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.password;
        }
        int n = pcInheritedFieldCount + 5;
        invitation.pcStateManager.accessingField(n);
        return invitation.password;
    }

    private static final void pcSetpassword(Invitation invitation, String string) {
        if (invitation.pcStateManager == null) {
            invitation.password = string;
            return;
        }
        invitation.pcStateManager.settingStringField((PersistenceCapable)invitation, pcInheritedFieldCount + 5, invitation.password, string, 0);
    }

    private static final boolean pcGetpasswordProtected(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.passwordProtected;
        }
        int n = pcInheritedFieldCount + 6;
        invitation.pcStateManager.accessingField(n);
        return invitation.passwordProtected;
    }

    private static final void pcSetpasswordProtected(Invitation invitation, boolean bl) {
        if (invitation.pcStateManager == null) {
            invitation.passwordProtected = bl;
            return;
        }
        invitation.pcStateManager.settingBooleanField((PersistenceCapable)invitation, pcInheritedFieldCount + 6, invitation.passwordProtected, bl, 0);
    }

    private static final Recording pcGetrecording(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.recording;
        }
        int n = pcInheritedFieldCount + 7;
        invitation.pcStateManager.accessingField(n);
        return invitation.recording;
    }

    private static final void pcSetrecording(Invitation invitation, Recording recording) {
        if (invitation.pcStateManager == null) {
            invitation.recording = recording;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 7, (Object)invitation.recording, (Object)recording, 0);
    }

    private static final Room pcGetroom(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.room;
        }
        int n = pcInheritedFieldCount + 8;
        invitation.pcStateManager.accessingField(n);
        return invitation.room;
    }

    private static final void pcSetroom(Invitation invitation, Room room) {
        if (invitation.pcStateManager == null) {
            invitation.room = room;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 8, (Object)invitation.room, (Object)room, 0);
    }

    private static final boolean pcGetused(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.used;
        }
        int n = pcInheritedFieldCount + 9;
        invitation.pcStateManager.accessingField(n);
        return invitation.used;
    }

    private static final void pcSetused(Invitation invitation, boolean bl) {
        if (invitation.pcStateManager == null) {
            invitation.used = bl;
            return;
        }
        invitation.pcStateManager.settingBooleanField((PersistenceCapable)invitation, pcInheritedFieldCount + 9, invitation.used, bl, 0);
    }

    private static final Valid pcGetvalid(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.valid;
        }
        int n = pcInheritedFieldCount + 10;
        invitation.pcStateManager.accessingField(n);
        return invitation.valid;
    }

    private static final void pcSetvalid(Invitation invitation, Valid valid) {
        if (invitation.pcStateManager == null) {
            invitation.valid = valid;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 10, (Object)invitation.valid, (Object)valid, 0);
    }

    private static final Date pcGetvalidFrom(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.validFrom;
        }
        int n = pcInheritedFieldCount + 11;
        invitation.pcStateManager.accessingField(n);
        return invitation.validFrom;
    }

    private static final void pcSetvalidFrom(Invitation invitation, Date date) {
        if (invitation.pcStateManager == null) {
            invitation.validFrom = date;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 11, (Object)invitation.validFrom, (Object)date, 0);
    }

    private static final Date pcGetvalidTo(Invitation invitation) {
        if (invitation.pcStateManager == null) {
            return invitation.validTo;
        }
        int n = pcInheritedFieldCount + 12;
        invitation.pcStateManager.accessingField(n);
        return invitation.validTo;
    }

    private static final void pcSetvalidTo(Invitation invitation, Date date) {
        if (invitation.pcStateManager == null) {
            invitation.validTo = date;
            return;
        }
        invitation.pcStateManager.settingObjectField((PersistenceCapable)invitation, pcInheritedFieldCount + 12, (Object)invitation.validTo, (Object)date, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    public static enum Valid {
        ONE_TIME(3),
        PERIOD(2),
        ENDLESS(1);

        private final int code;

        private Valid(int code) {
            this.code = code;
        }

        public static Valid fromInt(int valid) {
            return Stream.of(Valid.values()).filter(v -> v.code == valid).findAny().orElse(ONE_TIME);
        }
    }

    public static enum MessageType {
        CREATE,
        UPDATE,
        CANCEL;

    }
}

