/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import java.util.List;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.user.PrivateMessageFolder;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class PrivateMessageFolderDao
implements IDataProviderDao<PrivateMessageFolder> {
    private static final Logger log = LoggerFactory.getLogger(PrivateMessageFolderDao.class);
    @PersistenceContext
    private EntityManager em;

    public Long addPrivateMessageFolder(String folderName, Long userId) {
        try {
            PrivateMessageFolder privateMessageFolder = new PrivateMessageFolder();
            privateMessageFolder.setFolderName(folderName);
            privateMessageFolder.setUserId(userId);
            privateMessageFolder.setInserted(new Date());
            privateMessageFolder = (PrivateMessageFolder)this.em.merge((Object)privateMessageFolder);
            return privateMessageFolder.getId();
        }
        catch (Exception e) {
            log.error("[addPrivateMessageFolder]", (Throwable)e);
            return null;
        }
    }

    public Long addPrivateMessageFolderObj(PrivateMessageFolder folder) {
        folder.setInserted(new Date());
        folder = (PrivateMessageFolder)this.em.merge((Object)folder);
        return folder.getId();
    }

    @Override
    public PrivateMessageFolder get(Long id) {
        return (PrivateMessageFolder)DaoHelper.only(this.em.createNamedQuery("getMsgFolderById", PrivateMessageFolder.class).setParameter("id", (Object)id).getResultList());
    }

    public List<PrivateMessageFolder> getByUser(Long userId) {
        return this.em.createNamedQuery("getMsgFolderByUser", PrivateMessageFolder.class).setParameter("userId", (Object)userId).getResultList();
    }

    @Override
    public List<PrivateMessageFolder> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getMsgFolders", PrivateMessageFolder.class), start, count).getResultList();
    }

    @Override
    public PrivateMessageFolder update(PrivateMessageFolder folder, Long userId) {
        if (folder.getId() == null) {
            this.em.persist((Object)folder);
        } else {
            folder = (PrivateMessageFolder)this.em.merge((Object)folder);
        }
        return folder;
    }

    @Override
    public void delete(PrivateMessageFolder folder, Long userId) {
        folder = (PrivateMessageFolder)this.em.find(PrivateMessageFolder.class, (Object)folder.getId());
        this.em.remove((Object)folder);
    }

    @Override
    public List<PrivateMessageFolder> get(String search, long start, long count, SortParam<String> order) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count() {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count(String search) {
        throw DaoHelper.UNSUPPORTED;
    }
}

