/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.navbar;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.Navbar;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class NavbarAjaxLink<T>
extends AjaxLink<T> {
    private final Icon icon = new Icon("icon", (IconType)null);
    private final Label label;
    private final Component splitter;

    public NavbarAjaxLink() {
        this((IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public NavbarAjaxLink(IModel<String> label) {
        this(Navbar.componentId(), label);
    }

    public NavbarAjaxLink(String markupId, IModel<String> label) {
        super(markupId);
        this.label = new Label("label", label);
        this.label.setRenderBodyOnly(true);
        this.splitter = new WebMarkupContainer("splitter");
        this.add(new Component[]{this.icon, this.label, this.splitter});
    }

    @Deprecated
    public NavbarAjaxLink<T> setLabel(IModel<String> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    public NavbarAjaxLink<T> setIconType(IconType iconType) {
        this.icon.setType(iconType);
        return this;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.splitter.setVisible(this.icon.getType() != null);
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    protected void onComponentTag(ComponentTag tag) {
        if (!"a".equalsIgnoreCase(tag.getName()) && !"button".equalsIgnoreCase(tag.getName())) {
            tag.setName("a");
        }
        super.onComponentTag(tag);
    }
}

