/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ByteArrayResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileImageResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ProfileImageResourceReference.class);
    @Inject
    private UserDao userDao;

    public ProfileImageResourceReference() {
        super(ProfileImageResourceReference.class, "profile");
        Injector.get().inject((Object)this);
    }

    public String getUrl(RequestCycle rc, Long userId) {
        return ProfileImageResourceReference.getUrl(rc, this.userDao.get(userId));
    }

    public static String getUrl(RequestCycle rc, User u) {
        String uri = u.getPictureUri();
        if (ProfileImageResourceReference.isRelative(uri)) {
            File img = OmFileHelper.getUserProfilePicture((Long)u.getId(), (String)uri);
            uri = rc.urlFor((ResourceReference)new ProfileImageResourceReference(), new PageParameters().add("id", (Object)u.getId()).add("anticache", (Object)img.lastModified())).toString();
        }
        return uri;
    }

    private static boolean isRelative(String uri) {
        boolean relative = true;
        try {
            relative = !URI.create(uri).isAbsolute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return relative;
    }

    public IResource getResource() {
        return new ByteArrayResource("image/png"){
            private static final long serialVersionUID = 1L;
            private Long userId;
            private String uri;
            {
                this.userId = null;
                this.uri = null;
            }

            protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
                AbstractResource.ResourceResponse rr;
                if (WebSession.get().isSignedIn()) {
                    PageParameters params = attributes.getParameters();
                    try {
                        this.userId = params.get("id").toOptionalLong();
                        this.uri = OmFileHelper.SIP_USER_ID.equals(this.userId) ? null : ProfileImageResourceReference.this.userDao.get(this.userId).getPictureUri();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rr = super.newResourceResponse(attributes);
                    rr.disableCaching();
                } else {
                    log.debug("Not authorized");
                    rr = new AbstractResource.ResourceResponse();
                    rr.setError(Integer.valueOf(403));
                }
                return rr;
            }

            protected byte[] getData(IResource.Attributes attributes) {
                if (ProfileImageResourceReference.isRelative(this.uri)) {
                    byte[] byArray;
                    File img = OmFileHelper.getUserProfilePicture((Long)this.userId, (String)this.uri);
                    FileInputStream is = new FileInputStream(img);
                    try {
                        byArray = IOUtils.toByteArray((InputStream)is);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("failed to get bytes from image", (Throwable)e);
                        }
                    }
                    ((InputStream)is).close();
                    return byArray;
                }
                return null;
            }
        };
    }
}

