/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room;

import jakarta.inject.Inject;
import java.io.File;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.util.FileItemResourceReference;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;

public class RoomResourceReference
extends FileItemResourceReference<FileItem> {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "wb-room-file";
    @Inject
    private ClientManager cm;
    @Inject
    private FileItemDao fileDao;
    @Inject
    private GroupUserDao groupUserDao;

    public RoomResourceReference() {
        this(DEFAULT_NAME);
    }

    public RoomResourceReference(String name) {
        super(name);
        Injector.get().inject((Object)this);
    }

    @Override
    protected String getMimeType(FileItem r) {
        return r.isDeleted() ? "image/png" : (switch (r.getType()) {
            case BaseFileItem.Type.WML_FILE -> "application/json";
            case BaseFileItem.Type.IMAGE -> "image/png";
            case BaseFileItem.Type.PRESENTATION -> "image/png";
            case BaseFileItem.Type.VIDEO -> "video/mp4";
            default -> throw new RuntimeException("Not supported");
        });
    }

    @Override
    protected FileItem getFileItem(IResource.Attributes attr) {
        String wuid;
        PageParameters params = attr.getParameters();
        StringValue idStr = params.get("id");
        String uid = params.get("uid").toString();
        Long id = null;
        try {
            id = idStr.toOptionalLong();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        WebSession ws = WebSession.get();
        Client c = this.cm.get(uid);
        if (id == null || !ws.isSignedIn() || c == null) {
            return null;
        }
        FileItem f = (FileItem)this.fileDao.getAny(id);
        if (f == null) {
            return null;
        }
        String ruid = params.get("ruid").toString();
        if (this.isAtWb(c, ruid, wuid = params.get("wuid").toString(), f.getId())) {
            return f;
        }
        if (f.getGroupId() != null && this.groupUserDao.isUserInGroup(f.getGroupId().longValue(), WebSession.getUserId().longValue())) {
            return f;
        }
        return null;
    }

    protected File getFile(FileItem f, String ext) {
        File file = f.getFile(ext);
        if (file == null || !file.exists()) {
            file = new File(OmFileHelper.getImagesDir(), "deleted.png");
        }
        return file;
    }

    @Override
    protected File getFile(FileItem f, IResource.Attributes attr) {
        String ext = f.getType() == BaseFileItem.Type.PRESENTATION ? attr.getParameters().get("slide").toString() : null;
        return this.getFile(f, ext);
    }

    @Override
    protected String getFileName(FileItem f) {
        return f.getFileName(null);
    }
}

