/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AstState {
    public static final int AST_STATE_DOWN = 0;
    public static final int AST_STATE_RSRVD = 1;
    public static final int AST_STATE_OFFHOOK = 2;
    public static final int AST_STATE_DIALING = 3;
    public static final int AST_STATE_RING = 4;
    public static final int AST_STATE_RINGING = 5;
    public static final int AST_STATE_UP = 6;
    public static final int AST_STATE_BUSY = 7;
    public static final int AST_STATE_DIALING_OFFHOOK = 8;
    public static final int AST_STATE_PRERING = 9;
    private static final Map<String, Integer> inverseStateMap;
    private static final Pattern UNKNOWN_STATE_PATTERN;

    private AstState() {
    }

    public static Integer str2state(String str) {
        Matcher matcher;
        if (str == null) {
            return null;
        }
        Integer state = inverseStateMap.get(str);
        if (state == null && (matcher = UNKNOWN_STATE_PATTERN.matcher(str)).matches()) {
            try {
                state = Integer.valueOf(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to convert state '" + str + "' to integer representation", e);
            }
        }
        return state;
    }

    static {
        HashMap<String, Integer> tmpInverseStateMap = new HashMap<String, Integer>();
        tmpInverseStateMap.put("Down", 0);
        tmpInverseStateMap.put("Rsrvd", 1);
        tmpInverseStateMap.put("OffHook", 2);
        tmpInverseStateMap.put("Dialing", 3);
        tmpInverseStateMap.put("Ring", 4);
        tmpInverseStateMap.put("Ringing", 5);
        tmpInverseStateMap.put("Up", 6);
        tmpInverseStateMap.put("Busy", 7);
        tmpInverseStateMap.put("Dialing Offhook", 8);
        tmpInverseStateMap.put("Pre-ring", 9);
        inverseStateMap = Collections.unmodifiableMap(tmpInverseStateMap);
        UNKNOWN_STATE_PATTERN = Pattern.compile("^Unknown \\((\\d+)\\)$");
    }
}

