/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.activity;

import java.util.HashSet;
import java.util.LinkedList;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallDirection;
import org.asteriskjava.pbx.CallImpl;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.activities.JoinActivity;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.internal.activity.ActivityHelper;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class JoinActivityImpl
extends ActivityHelper<JoinActivity>
implements JoinActivity {
    private static final Log logger = LogFactory.getLog(JoinActivityImpl.class);
    private final Call _lhsCall;
    private final Call.OperandChannel _originatingOperand;
    private final Call _rhsCall;
    private final Call.OperandChannel _acceptingOperand;
    private final CallDirection _direction;
    private Call _joined;
    private Exception callSite = new Exception("Call site");

    public JoinActivityImpl(Call lhsCall, Call.OperandChannel originatingOperand, Call rhsCall, Call.OperandChannel acceptingOperand, CallDirection direction, ActivityCallback<JoinActivity> listener) {
        super("JoinActivity", listener);
        this._lhsCall = lhsCall;
        this._originatingOperand = originatingOperand;
        this._rhsCall = rhsCall;
        this._acceptingOperand = acceptingOperand;
        this._direction = direction;
        if (this._lhsCall == null) {
            throw new IllegalArgumentException("lhsCall may not be null");
        }
        if (this._originatingOperand == null) {
            throw new IllegalArgumentException("lhsOperand may not be null");
        }
        if (this._rhsCall == null) {
            throw new IllegalArgumentException("rhsCall may not be null");
        }
        if (this._acceptingOperand == null) {
            throw new IllegalArgumentException("rhsOperand may not be null");
        }
        this.startActivity(true);
    }

    @Override
    public boolean doActivity() throws PBXException {
        boolean success = false;
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        logger.debug("*******************************************************************************");
        logger.info("***********                    begin join               ****************");
        logger.info("***********            " + this._lhsCall + "                 ****************");
        logger.debug("***********            " + this._rhsCall + "                 ****************");
        logger.debug("*******************************************************************************");
        try {
            Channel rhsChannel = this._rhsCall.getOperandChannel(this._acceptingOperand);
            Channel lhsChannel = this._lhsCall.getOperandChannel(this._originatingOperand);
            if (!pbx.moveChannelToAgi(rhsChannel)) {
                throw new PBXException("Channel: " + rhsChannel + " couldn't be moved to agi");
            }
            if (!pbx.moveChannelToAgi(lhsChannel)) {
                throw new PBXException("Channel: " + lhsChannel + " couldn't be moved to agi");
            }
            LinkedList<Channel> channels = new LinkedList<Channel>();
            channels.add(lhsChannel);
            channels.add(rhsChannel);
            if (!pbx.waitForChannelsToQuiescent(channels, 3000L)) {
                logger.error(this.callSite, this.callSite);
                throw new PBXException("Channel: " + rhsChannel + " cannot be joined as it is still in transition.");
            }
            pbx.bridge(lhsChannel, rhsChannel);
            this._joined = ((CallImpl)this._lhsCall).join(this._originatingOperand, this._rhsCall, this._acceptingOperand, this._direction);
            success = true;
        }
        catch (RuntimeException e) {
            logger.error(e, e);
            logger.error(this.callSite, this.callSite);
            throw new PBXException(e);
        }
        return success;
    }

    @Override
    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        return required;
    }

    @Override
    public synchronized void onManagerEvent(ManagerEvent event) {
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    @Override
    public Call getJoinedCall() {
        return this._joined;
    }
}

