/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.kurento.jsonrpc.JsonRpcErrorException;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.internal.JsonRpcRequestSender;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;

public abstract class JsonRpcRequestSenderHelper
implements JsonRpcRequestSender {
    protected AtomicInteger id = new AtomicInteger();
    protected String sessionId;

    public JsonRpcRequestSenderHelper() {
    }

    public JsonRpcRequestSenderHelper(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public <R> R sendRequest(String method, Class<R> resultClass) throws IOException {
        return this.sendRequest(method, null, resultClass);
    }

    @Override
    public <R> R sendRequest(String method, Object params, Class<R> resultClass) throws IOException {
        Request<Object> request = new Request<Object>(null, method, params);
        this.setIdIfNecessary(request);
        request.setSessionId(this.sessionId);
        return this.sendRequest(request, resultClass);
    }

    public <P, R> R sendRequest(Request<P> request, Class<R> resultClass) throws JsonRpcErrorException, IOException {
        Response<R> response = this.internalSendRequest(request, resultClass);
        if (response == null) {
            return null;
        }
        if (response.getSessionId() != null) {
            this.sessionId = response.getSessionId();
        }
        if (response.getError() != null) {
            throw new JsonRpcErrorException(response.getError());
        }
        return response.getResult();
    }

    @Override
    public JsonElement sendRequest(String method) throws IOException {
        return this.sendRequest(method, JsonElement.class);
    }

    @Override
    public JsonElement sendRequest(String method, Object params) throws IOException {
        return this.sendRequest(method, params, JsonElement.class);
    }

    @Override
    public void sendRequest(String method, JsonObject params, final Continuation<JsonElement> continuation) {
        Request<JsonObject> request = new Request<JsonObject>(this.id.incrementAndGet(), method, params);
        request.setSessionId(this.sessionId);
        this.internalSendRequest(request, JsonElement.class, new Continuation<Response<JsonElement>>(){

            @Override
            public void onSuccess(Response<JsonElement> response) {
                if (response == null) {
                    continuation.onSuccess(null);
                    return;
                }
                if (response.getSessionId() != null) {
                    JsonRpcRequestSenderHelper.this.sessionId = response.getSessionId();
                }
                if (response.getError() != null) {
                    continuation.onError((Throwable)((Object)new JsonRpcErrorException(response.getError())));
                } else {
                    continuation.onSuccess(response.getResult());
                }
            }

            @Override
            public void onError(Throwable cause) {
                continuation.onError(cause);
            }
        });
    }

    @Override
    public void sendNotification(String method) throws IOException {
        this.sendNotification(method, null);
    }

    @Override
    public void sendNotification(String method, Object params) throws IOException {
        Request<Object> request = new Request<Object>(null, method, params);
        request.setSessionId(this.sessionId);
        this.sendRequest(request, Void.class);
    }

    @Override
    public void sendNotification(String method, Object params, Continuation<JsonElement> continuation) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response<JsonElement> sendRequest(Request<JsonObject> request) throws IOException {
        this.setIdIfNecessary(request);
        return this.internalSendRequest(request, JsonElement.class);
    }

    private void setIdIfNecessary(Request<? extends Object> request) {
        if (request.getId() == null) {
            request.setId(this.id.incrementAndGet());
        }
    }

    @Override
    public void sendRequest(Request<JsonObject> request, Continuation<Response<JsonElement>> continuation) {
        this.setIdIfNecessary(request);
        this.internalSendRequest(request, JsonElement.class, continuation);
    }

    @Override
    public Response<JsonElement> sendRequestHonorId(Request<JsonObject> request) throws IOException {
        return this.internalSendRequest(request, JsonElement.class);
    }

    @Override
    public void sendRequestHonorId(Request<JsonObject> request, Continuation<Response<JsonElement>> continuation) throws IOException {
        this.internalSendRequest(request, JsonElement.class, continuation);
    }

    protected abstract <P, R> Response<R> internalSendRequest(Request<P> var1, Class<R> var2) throws IOException;

    protected abstract void internalSendRequest(Request<? extends Object> var1, Class<JsonElement> var2, Continuation<Response<JsonElement>> var3);
}

