/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.kurento.jsonrpc.DefaultJsonRpcHandler;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.message.MessageUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcHandlerManager {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcHandlerManager.class);
    private JsonRpcHandler<?> handler;

    public JsonRpcHandlerManager(JsonRpcHandler<?> handler) {
        this.handler = handler;
    }

    public JsonRpcHandlerManager() {
    }

    public void setJsonRpcHandler(JsonRpcHandler<?> handler) {
        this.handler = handler;
    }

    public void afterConnectionClosed(Session session, String reason) {
        if (this.handler != null) {
            try {
                this.handler.afterConnectionClosed(session, reason);
            }
            catch (Exception e) {
                try {
                    this.handler.handleUncaughtException(session, e);
                }
                catch (Exception e2) {
                    log.error("Exception while executing handleUncaughtException", (Throwable)e2);
                }
            }
        }
    }

    public void afterConnectionEstablished(Session session) {
        try {
            if (this.handler != null) {
                this.handler.afterConnectionEstablished(session);
            }
        }
        catch (Exception e) {
            try {
                this.handler.handleUncaughtException(session, e);
            }
            catch (Exception e2) {
                log.error("Exception while executing handleUncaughtException", (Throwable)e2);
            }
        }
    }

    public void afterReconnection(Session session) {
        if (this.handler != null) {
            try {
                this.handler.afterReconnection(session);
            }
            catch (Exception e) {
                try {
                    this.handler.handleUncaughtException(session, e);
                }
                catch (Exception e2) {
                    log.error("Exception while executing handleUncaughtException", (Throwable)e2);
                }
            }
        }
    }

    public void handleRequest(Session session, Request<JsonElement> request, TransactionImpl.ResponseSender rs) {
        try {
            Request<?> nonGenRequest;
            if (this.handler == null) {
                log.warn("JsonRpcClient has received a request from server but there is no JsonRpcHandler configured to manage this request");
                return;
            }
            Class<?> paramsType = JsonRpcHandlerManager.getParamsType(this.handler.getHandlerType());
            try {
                nonGenRequest = MessageUtils.convertRequest(request, paramsType);
            }
            catch (ClassCastException e) {
                String message = "The handler " + String.valueOf(this.handler.getClass()) + " is trying to process the request. But request params '" + String.valueOf(request.getParams()) + "' cannot be converted to " + paramsType.getCanonicalName() + ". The type to convert params is specified in the handler as the supertype generic parameter";
                log.error(message, (Throwable)e);
                if (request.getId() != null) {
                    rs.sendResponse(new Response(null, new ResponseError(0, message)));
                }
                return;
            }
            JsonRpcHandler<?> nonGenHandler = this.handler;
            TransactionImpl tx = new TransactionImpl(session, request, rs);
            nonGenHandler.handleRequest(tx, nonGenRequest);
            if (!tx.isAsync() && request.getId() != null) {
                log.debug("Request {} is processed asynchronously", request);
                boolean notResponded = tx.setRespondedIfNot();
                if (notResponded) {
                    rs.sendResponse(new Response<String>(request.getId(), ""));
                }
            }
        }
        catch (Exception e) {
            log.error("Exception while processing request {}", request, (Object)e);
            ResponseError error = ResponseError.newFromException(e);
            try {
                rs.sendResponse(new Response(request.getId(), error));
            }
            catch (IOException e1) {
                log.error("Exception sending error to client", (Throwable)e1);
            }
        }
    }

    public static Class<?> getParamsType(Class<?> handlerClass) {
        Type[] genericInterfaces;
        for (Type type : genericInterfaces = handlerClass.getGenericInterfaces()) {
            ParameterizedType parameterized;
            if (!(type instanceof ParameterizedType) || (parameterized = (ParameterizedType)type).getRawType() != JsonRpcHandler.class) continue;
            return (Class)parameterized.getActualTypeArguments()[0];
        }
        Type genericSuperclass = handlerClass.getGenericSuperclass();
        if (genericSuperclass != null) {
            if (genericSuperclass instanceof Class) {
                return JsonRpcHandlerManager.getParamsType((Class)genericSuperclass);
            }
            ParameterizedType paramClass = (ParameterizedType)genericSuperclass;
            if (paramClass.getRawType() == DefaultJsonRpcHandler.class) {
                return (Class)paramClass.getActualTypeArguments()[0];
            }
            return JsonRpcHandlerManager.getParamsType((Class)paramClass.getRawType());
        }
        throw new JsonRpcException("Unable to obtain the type paramter of JsonRpcHandler");
    }

    public void handleTransportError(Session session, Throwable exception) {
        if (this.handler != null) {
            try {
                this.handler.handleTransportError(session, exception);
            }
            catch (Exception e) {
                try {
                    this.handler.handleUncaughtException(session, e);
                }
                catch (Exception e2) {
                    log.error("Exception while executing handleUncaughtException", (Throwable)e2);
                }
            }
        }
    }

    public JsonRpcHandler<?> getHandler() {
        return this.handler;
    }
}

