/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;

public final class MimeUtil {
    public static final String ENC_QUOTED_PRINTABLE = "quoted-printable";
    public static final String ENC_BINARY = "binary";
    public static final String ENC_BASE64 = "base64";
    public static final String ENC_8BIT = "8bit";
    public static final String ENC_7BIT = "7bit";
    public static final int DEFAULT_MAX_CHARACTERS = 76;
    private static final Random random = new Random();
    private static int counter = 0;
    private static final int INITIAL_YEAR = 1970;
    public static final DateTimeFormatter RFC822_DATE_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendText((TemporalField)ChronoField.DAY_OF_WEEK, MimeUtil.dayOfWeek()).appendLiteral(", ").appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, MimeUtil.monthOfYear()).appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 4, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendOffset("+HHMM", "+0000").toFormatter().withZone(TimeZone.getDefault().toZoneId()).withLocale(Locale.US);

    private MimeUtil() {
    }

    public static boolean isSameMimeType(String pType1, String pType2) {
        return pType1 != null && pType2 != null && pType1.equalsIgnoreCase(pType2);
    }

    public static boolean isMessage(String pMimeType) {
        return pMimeType != null && pMimeType.equalsIgnoreCase("message/rfc822");
    }

    public static boolean isMultipart(String pMimeType) {
        return pMimeType != null && pMimeType.toLowerCase().startsWith("multipart/");
    }

    public static boolean isBase64Encoding(String pTransferEncoding) {
        return ENC_BASE64.equalsIgnoreCase(pTransferEncoding);
    }

    public static boolean isQuotedPrintableEncoded(String pTransferEncoding) {
        return ENC_QUOTED_PRINTABLE.equalsIgnoreCase(pTransferEncoding);
    }

    public static String createUniqueBoundary() {
        StringBuilder sb = new StringBuilder();
        sb.append("-=Part.");
        sb.append(Integer.toHexString(MimeUtil.nextCounterValue()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append('.');
        sb.append(Long.toHexString(System.currentTimeMillis()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append("=-");
        return sb.toString();
    }

    public static String createUniqueMessageId(String hostName) {
        StringBuilder sb = new StringBuilder("<Mime4j.");
        sb.append(Integer.toHexString(MimeUtil.nextCounterValue()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append('.');
        sb.append(Long.toHexString(System.currentTimeMillis()));
        if (hostName != null) {
            sb.append('@');
            sb.append(hostName);
        }
        sb.append('>');
        return sb.toString();
    }

    public static String formatDate(Date date, TimeZone zone) {
        return RFC822_DATE_FORMAT.withZone(MimeUtil.zone(zone)).format(date.toInstant());
    }

    private static ZoneId zone(TimeZone zone) {
        if (zone == null) {
            return TimeZone.getDefault().toZoneId();
        }
        return zone.toZoneId();
    }

    public static String fold(String s, int usedCharacters, int maxCharacters) {
        int length = s.length();
        if (usedCharacters + length <= maxCharacters) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int lastLineBreak = -usedCharacters;
        int wspIdx = MimeUtil.indexOfWsp(s, 0);
        while (true) {
            if (wspIdx == length) {
                sb.append(s.substring(Math.max(0, lastLineBreak)));
                return sb.toString();
            }
            int nextWspIdx = MimeUtil.indexOfWsp(s, wspIdx + 1);
            if (nextWspIdx - lastLineBreak > maxCharacters) {
                sb.append(s, Math.max(0, lastLineBreak), wspIdx);
                sb.append("\r\n");
                lastLineBreak = wspIdx;
            }
            wspIdx = nextWspIdx;
        }
    }

    public static String fold(String s, int usedCharacters) {
        return MimeUtil.fold(s, usedCharacters, 76);
    }

    public static String unfold(String s) {
        int length = s.length();
        for (int idx = 0; idx < length; ++idx) {
            char c = s.charAt(idx);
            if (c != '\r' && c != '\n') continue;
            return MimeUtil.unfold0(s, idx);
        }
        return s;
    }

    public static String unscrambleHeaderValue(String headerValue) {
        return DecoderUtil.decodeEncodedWords(MimeUtil.unfold(headerValue), DecodeMonitor.SILENT);
    }

    private static String unfold0(String s, int crlfIdx) {
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        if (crlfIdx > 0) {
            sb.append(s, 0, crlfIdx);
        }
        int lastLineBreak = crlfIdx;
        for (int idx = crlfIdx + 1; idx < length; ++idx) {
            char c = s.charAt(idx);
            if (c != '\r' && c != '\n') continue;
            if (idx > lastLineBreak + 1) {
                sb.append(s, lastLineBreak + 1, idx);
            }
            lastLineBreak = idx;
        }
        if (lastLineBreak < s.length() - 1 && s.length() > 0) {
            sb.append(s, lastLineBreak + 1, s.length());
        }
        return sb.toString();
    }

    private static int indexOfWsp(String s, int fromIndex) {
        int len = s.length();
        for (int index = fromIndex; index < len; ++index) {
            char c = s.charAt(index);
            if (c != ' ' && c != '\t') continue;
            return index;
        }
        return len;
    }

    private static synchronized int nextCounterValue() {
        return counter++;
    }

    private static Map<Long, String> monthOfYear() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        result.put(1L, "Jan");
        result.put(2L, "Feb");
        result.put(3L, "Mar");
        result.put(4L, "Apr");
        result.put(5L, "May");
        result.put(6L, "Jun");
        result.put(7L, "Jul");
        result.put(8L, "Aug");
        result.put(9L, "Sep");
        result.put(10L, "Oct");
        result.put(11L, "Nov");
        result.put(12L, "Dec");
        return result;
    }

    private static Map<Long, String> dayOfWeek() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        result.put(1L, "Mon");
        result.put(2L, "Tue");
        result.put(3L, "Wed");
        result.put(4L, "Thu");
        result.put(5L, "Fri");
        result.put(6L, "Sat");
        result.put(7L, "Sun");
        return result;
    }
}

