/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonToken;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.api.CollectionBuilder;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.JSONReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionReader
extends ValueReader {
    protected final Class<?> _collectionType;
    protected final ValueReader _valueReader;

    public CollectionReader(Class<?> clazz, ValueReader valueReader) {
        super(clazz);
        this._collectionType = clazz == Collection.class || clazz == List.class ? null : (clazz == Set.class ? HashSet.class : (clazz == SortedSet.class ? TreeSet.class : clazz));
        this._valueReader = valueReader;
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                return null;
            }
            throw JSONObjectException.from(jsonParser, "Unexpected token " + (Object)((Object)jsonParser.currentToken()) + "; should get START_ARRAY");
        }
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(this._collectionType);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyCollection();
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonCollection(object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildCollection();
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(this._collectionType);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyCollection();
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonCollection(object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildCollection();
    }
}

