/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.submitjob.clientside.upload;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.internal.util.Sha256Util;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.impl.submitjob.clientside.SubmitJobTargetMemberFinder;
import com.hazelcast.jet.impl.submitjob.clientside.upload.SubmitJobPartCalculator;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;

public class JobUploadCall {
    private UUID sessionId;
    private UUID memberUuid;
    private String fileNameWithoutExtension;
    private String sha256HexOfJar;
    private int partSize;
    private int totalParts;

    public byte[] allocatePartBuffer() {
        return new byte[this.partSize];
    }

    public byte[] getDataToSend(byte[] partBuffer, int bytesRead) {
        byte[] dataToSend = bytesRead != partBuffer.length ? Arrays.copyOf(partBuffer, bytesRead) : partBuffer;
        return dataToSend;
    }

    public void initializeJobUploadCall(HazelcastClientInstanceImpl client, Path jarPath) throws IOException, NoSuchAlgorithmException {
        this.sessionId = UuidUtil.newSecureUUID();
        this.fileNameWithoutExtension = this.findFileNameWithoutExtension(jarPath);
        this.sha256HexOfJar = Sha256Util.calculateSha256Hex(jarPath);
        long jarSize = Files.size(jarPath);
        SubmitJobPartCalculator calculator = new SubmitJobPartCalculator();
        HazelcastProperties hazelcastProperties = client.getProperties();
        this.partSize = calculator.calculatePartBufferSize(hazelcastProperties, jarSize);
        this.totalParts = calculator.calculateTotalParts(jarSize, this.partSize);
        SubmitJobTargetMemberFinder submitJobTargetMemberFinder = new SubmitJobTargetMemberFinder();
        this.memberUuid = submitJobTargetMemberFinder.getRandomMemberId(client);
    }

    String findFileNameWithoutExtension(Path jarPath) {
        String fileName = jarPath.getFileName().toString();
        int endIndex = fileName.lastIndexOf(46);
        if (endIndex != -1) {
            fileName = fileName.substring(0, endIndex);
        }
        return fileName;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public UUID getMemberUuid() {
        return this.memberUuid;
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameWithoutExtension;
    }

    public void setFileNameWithoutExtension(String fileNameWithoutExtension) {
        this.fileNameWithoutExtension = fileNameWithoutExtension;
    }

    public String getSha256HexOfJar() {
        return this.sha256HexOfJar;
    }

    public void setSha256HexOfJar(String sha256HexOfJar) {
        this.sha256HexOfJar = sha256HexOfJar;
    }

    public int getTotalParts() {
        return this.totalParts;
    }
}

