/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.impl.CacheEntriesWithCursor;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.protocol.codec.CacheIterateEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchWithQueryCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.ReadMapOrCacheP;
import com.hazelcast.jet.impl.connector.RemoteMapSourceConfiguration;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.map.impl.query.ResultSegment;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.PermissionsUtil;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.io.IOException;
import java.security.Permission;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class HazelcastReaders {
    private HazelcastReaders() {
    }

    @Nonnull
    public static ProcessorMetaSupplier readLocalCacheSupplier(final @Nonnull String cacheName) {
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier<InternalCompletableFuture<CacheEntriesWithCursor>, CacheEntriesWithCursor, Map.Entry<Data, Data>>((BiFunctionEx)new LocalCacheReaderFunction(cacheName)){
            private static final long serialVersionUID = 1L;

            @Override
            public Permission getRequiredPermission() {
                return new CachePermission(cacheName, "create", "read");
            }
        };
    }

    @Nonnull
    public static ProcessorSupplier readRemoteCacheSupplier(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return new ReadMapOrCacheP.RemoteProcessorSupplier<ClientInvocationFuture, CacheIterateEntriesCodec.ResponseParameters, Map.Entry<Data, Data>>(null, clientXml, new RemoteCacheReaderFunction(cacheName));
    }

    @Nonnull
    public static ProcessorMetaSupplier readLocalMapSupplier(final @Nonnull String mapName) {
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier<InternalCompletableFuture<MapEntriesWithCursor>, MapEntriesWithCursor, Map.Entry<Data, Data>>((BiFunctionEx)new LocalMapReaderFunction(mapName)){
            private static final long serialVersionUID = 1L;

            @Override
            public Permission getRequiredPermission() {
                return new MapPermission(mapName, "create", "read");
            }
        };
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier readLocalMapSupplier(final @Nonnull String mapName, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        Util.checkSerializable(Objects.requireNonNull(predicate), "predicate");
        Util.checkSerializable(Objects.requireNonNull(projection), "projection");
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier<InternalCompletableFuture<ResultSegment>, ResultSegment, QueryResultRow>(new LocalMapQueryReaderFunction<K, V, T>(mapName, predicate, projection)){
            private static final long serialVersionUID = 1L;

            @Override
            public Permission getRequiredPermission() {
                return new MapPermission(mapName, "create", "read");
            }
        };
    }

    @Nonnull
    public static <T, K, V> ProcessorSupplier readRemoteMapSupplier(RemoteMapSourceConfiguration<K, V, T> config) {
        String clientXml = ImdgUtil.asXmlString(config.getClientConfig());
        if (config.hasPredicate()) {
            RemoteMapQueryReaderFunction<K, V, T> readerSupplier = new RemoteMapQueryReaderFunction<K, V, T>(config.getName(), config.getPredicate(), config.getProjection());
            return new ReadMapOrCacheP.RemoteProcessorSupplier<ClientInvocationFuture, MapFetchWithQueryCodec.ResponseParameters, Data>(config.getDataConnectionName(), clientXml, readerSupplier);
        }
        RemoteMapReaderFunction readerSupplier = new RemoteMapReaderFunction(config.getName());
        return new ReadMapOrCacheP.RemoteProcessorSupplier<ClientInvocationFuture, MapFetchEntriesCodec.ResponseParameters, Map.Entry<Data, Data>>(config.getDataConnectionName(), clientXml, readerSupplier);
    }

    public static ProcessorMetaSupplier localOrRemoteListSupplier(String name, ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        Permission permission = PermissionsUtil.listReadPermission(clientXml, name);
        return ProcessorMetaSupplier.forceTotalParallelismOne(ProcessorSupplier.of(SecuredFunctions.readListProcessorFn(name, clientXml)), name, permission);
    }

    public static class LocalCacheReaderFunction
    implements BiFunctionEx<HazelcastInstance, InternalSerializationService, ReadMapOrCacheP.Reader<InternalCompletableFuture<CacheEntriesWithCursor>, CacheEntriesWithCursor, Map.Entry<Data, Data>>>,
    IdentifiedDataSerializable {
        private static final long serialVersionUID = 1L;
        private String cacheName;

        public LocalCacheReaderFunction() {
        }

        public LocalCacheReaderFunction(String cacheName) {
            this.cacheName = cacheName;
        }

        @Override
        public ReadMapOrCacheP.Reader<InternalCompletableFuture<CacheEntriesWithCursor>, CacheEntriesWithCursor, Map.Entry<Data, Data>> applyEx(HazelcastInstance hzInstance, InternalSerializationService serializationService) throws Exception {
            return new ReadMapOrCacheP.LocalCacheReader(hzInstance, serializationService, this.cacheName);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.cacheName);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.cacheName = in.readString();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 9;
        }
    }

    public static class RemoteCacheReaderFunction
    implements FunctionEx<HazelcastInstance, ReadMapOrCacheP.Reader<ClientInvocationFuture, CacheIterateEntriesCodec.ResponseParameters, Map.Entry<Data, Data>>>,
    IdentifiedDataSerializable {
        private static final long serialVersionUID = 1L;
        private String cacheName;

        public RemoteCacheReaderFunction() {
        }

        public RemoteCacheReaderFunction(String cacheName) {
            this.cacheName = cacheName;
        }

        @Override
        public ReadMapOrCacheP.Reader<ClientInvocationFuture, CacheIterateEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> applyEx(HazelcastInstance hzInstance) throws Exception {
            return new ReadMapOrCacheP.RemoteCacheReader(hzInstance, this.cacheName);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.cacheName);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.cacheName = in.readString();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 10;
        }
    }

    public static class LocalMapReaderFunction
    implements BiFunctionEx<HazelcastInstance, InternalSerializationService, ReadMapOrCacheP.Reader<InternalCompletableFuture<MapEntriesWithCursor>, MapEntriesWithCursor, Map.Entry<Data, Data>>>,
    IdentifiedDataSerializable {
        private static final long serialVersionUID = 1L;
        private String mapName;

        public LocalMapReaderFunction() {
        }

        public LocalMapReaderFunction(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public ReadMapOrCacheP.Reader<InternalCompletableFuture<MapEntriesWithCursor>, MapEntriesWithCursor, Map.Entry<Data, Data>> applyEx(HazelcastInstance instance, InternalSerializationService serializationService) throws Exception {
            return new ReadMapOrCacheP.LocalMapReader(instance, serializationService, this.mapName);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.mapName);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readString();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 7;
        }
    }

    public static class LocalMapQueryReaderFunction<K, V, T>
    implements BiFunctionEx<HazelcastInstance, InternalSerializationService, ReadMapOrCacheP.Reader<InternalCompletableFuture<ResultSegment>, ResultSegment, QueryResultRow>>,
    IdentifiedDataSerializable {
        private static final long serialVersionUID = 1L;
        private String mapName;
        private Predicate<? super K, ? super V> predicate;
        private Projection<? super Map.Entry<K, V>, ? extends T> projection;

        public LocalMapQueryReaderFunction() {
        }

        public LocalMapQueryReaderFunction(String mapName, Predicate<? super K, ? super V> predicate, Projection<? super Map.Entry<K, V>, ? extends T> projection) {
            this.mapName = mapName;
            this.predicate = predicate;
            this.projection = projection;
        }

        @Override
        public ReadMapOrCacheP.Reader<InternalCompletableFuture<ResultSegment>, ResultSegment, QueryResultRow> applyEx(HazelcastInstance hzInstance, InternalSerializationService serializationService) throws Exception {
            return new ReadMapOrCacheP.LocalMapQueryReader(hzInstance, serializationService, this.mapName, this.predicate, this.projection);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.mapName);
            out.writeObject(this.predicate);
            out.writeObject(this.projection);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readString();
            this.predicate = (Predicate)in.readObject();
            this.projection = (Projection)in.readObject();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 11;
        }
    }

    public static class RemoteMapQueryReaderFunction<K, V, T>
    implements FunctionEx<HazelcastInstance, ReadMapOrCacheP.Reader<ClientInvocationFuture, MapFetchWithQueryCodec.ResponseParameters, Data>>,
    IdentifiedDataSerializable {
        private static final long serialVersionUID = 1L;
        private String mapName;
        private Predicate<? super K, ? super V> predicate;
        private Projection<? super Map.Entry<K, V>, ? extends T> projection;

        public RemoteMapQueryReaderFunction() {
        }

        public RemoteMapQueryReaderFunction(String mapName, Predicate<? super K, ? super V> predicate, Projection<? super Map.Entry<K, V>, ? extends T> projection) {
            this.mapName = mapName;
            this.predicate = predicate;
            this.projection = projection;
        }

        @Override
        public ReadMapOrCacheP.Reader<ClientInvocationFuture, MapFetchWithQueryCodec.ResponseParameters, Data> applyEx(HazelcastInstance hzInstance) throws Exception {
            return new ReadMapOrCacheP.RemoteMapQueryReader(hzInstance, this.mapName, this.predicate, this.projection);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.mapName);
            out.writeObject(this.predicate);
            out.writeObject(this.projection);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readString();
            this.predicate = (Predicate)in.readObject();
            this.projection = (Projection)in.readObject();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 13;
        }
    }

    public static class RemoteMapReaderFunction
    implements FunctionEx<HazelcastInstance, ReadMapOrCacheP.Reader<ClientInvocationFuture, MapFetchEntriesCodec.ResponseParameters, Map.Entry<Data, Data>>>,
    IdentifiedDataSerializable {
        private static final long serialVersionUID = 1L;
        private String mapName;

        public RemoteMapReaderFunction() {
        }

        public RemoteMapReaderFunction(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public ReadMapOrCacheP.Reader<ClientInvocationFuture, MapFetchEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> applyEx(HazelcastInstance hzInstance) throws Exception {
            return new ReadMapOrCacheP.RemoteMapReader(hzInstance, this.mapName);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.mapName);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readString();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 12;
        }
    }
}

