/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.config.Config;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.stream.Stream;

class StorageMetricsProvider
implements MetricsProvider {
    StorageMetricsProvider() {
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        this.memory(node, context);
        this.tieredStorage(node.getConfig(), context);
        this.dataMemoryCost(node.getNodeEngine(), context);
    }

    private void memory(Node node, MetricsCollectionContext context) {
        NativeMemoryConfig nativeMemoryConfig = node.getConfig().getNativeMemoryConfig();
        boolean isHdEnabled = nativeMemoryConfig.isEnabled();
        context.collect(PhoneHomeMetrics.HD_MEMORY_ENABLED, isHdEnabled);
        MemoryStats memoryStats = node.getNodeExtension().getMemoryStats();
        if (isHdEnabled) {
            context.collect(PhoneHomeMetrics.MEMORY_USED_NATIVE_SIZE, memoryStats.getUsedNative());
        }
        context.collect(PhoneHomeMetrics.MEMORY_USED_HEAP_SIZE, memoryStats.getUsedHeap());
        context.collect(PhoneHomeMetrics.MEMORY_FREE_HEAP_SIZE, memoryStats.getFreeHeap());
    }

    private void tieredStorage(Config config, MetricsCollectionContext context) {
        boolean tieredStorageEnabled = config.getMapConfigs().values().stream().anyMatch(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled());
        context.collect(PhoneHomeMetrics.TIERED_STORAGE_ENABLED, tieredStorageEnabled);
    }

    private void dataMemoryCost(NodeEngine nodeEngine, MetricsCollectionContext context) {
        MapService mapService = (MapService)nodeEngine.getService("hz:impl:mapService");
        ReplicatedMapService replicatedMapService = (ReplicatedMapService)nodeEngine.getService("hz:impl:replicatedMapService");
        long totalEntryMemoryCost = Stream.concat(mapService.getStats().values().stream(), replicatedMapService.getStats().values().stream()).mapToLong(LocalMapStats::getOwnedEntryMemoryCost).sum();
        context.collect(PhoneHomeMetrics.DATA_MEMORY_COST, totalEntryMemoryCost);
    }
}

