/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.connection.tcp.RoutingMode;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.util.EnumMap;

public class ClientRoutingModeMetricsProvider
implements MetricsProvider {
    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        EnumMap<RoutingMode, Integer> routingModeCounts = new EnumMap<RoutingMode, Integer>(RoutingMode.class);
        for (ClientEndpoint client : node.getClientEngine().getEndpointManager().getEndpoints()) {
            RoutingMode mode = client.getRoutingMode();
            if (!mode.isKnown()) continue;
            routingModeCounts.put(mode, routingModeCounts.getOrDefault((Object)mode, 0) + 1);
        }
        context.collect(PhoneHomeMetrics.ALL_MEMBERS_CLIENTS_COUNT, routingModeCounts.getOrDefault((Object)RoutingMode.ALL_MEMBERS, 0));
        context.collect(PhoneHomeMetrics.SINGLE_MEMBER_CLIENTS_COUNT, routingModeCounts.getOrDefault((Object)RoutingMode.SINGLE_MEMBER, 0));
        context.collect(PhoneHomeMetrics.MULTI_MEMBER_CLIENTS_COUNT, routingModeCounts.getOrDefault((Object)RoutingMode.MULTI_MEMBER, 0));
    }
}

