/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine;

import com.hazelcast.internal.tpcengine.Eventloop;
import com.hazelcast.internal.tpcengine.Promise;
import com.hazelcast.internal.tpcengine.util.Preconditions;

public final class PromiseAllocator {
    private final Eventloop eventloop;
    private final Promise[] array;
    private int index = -1;

    public PromiseAllocator(Eventloop eventloop, int capacity) {
        this.eventloop = Preconditions.checkNotNull(eventloop);
        this.array = new Promise[capacity];
    }

    public int size() {
        return this.index + 1;
    }

    Promise allocate() {
        if (this.index == -1) {
            Promise promise = new Promise(this.eventloop);
            promise.allocator = this;
            return promise;
        }
        Promise promise = this.array[this.index];
        this.array[this.index] = null;
        --this.index;
        promise.refCount = 1;
        return promise;
    }

    void free(Promise e) {
        Preconditions.checkNotNull(e);
        if (this.index <= this.array.length - 1) {
            ++this.index;
            this.array[this.index] = e;
        }
    }
}

