/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.dynamicconfig.ClusterWideConfigurationService;
import com.hazelcast.internal.dynamicconfig.ConfigCheckMode;
import com.hazelcast.internal.dynamicconfig.UpdateDynamicConfigOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import javax.annotation.Nullable;

public class AddDynamicConfigOperation
extends UpdateDynamicConfigOperation
implements Versioned {
    public AddDynamicConfigOperation() {
    }

    public AddDynamicConfigOperation(IdentifiedDataSerializable config, int memberListVersion, @Nullable String namespace) {
        super(config, memberListVersion, namespace);
    }

    @Override
    public void run() throws Exception {
        ClusterWideConfigurationService service = (ClusterWideConfigurationService)this.getService();
        service.registerConfigLocally(this.config, ConfigCheckMode.THROW_EXCEPTION);
        super.run();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            super.writeInternal(out);
        } else {
            out.writeObject(this.config);
            out.writeInt(this.memberListVersion);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        if (in.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            super.readInternal(in);
        } else {
            this.config = (IdentifiedDataSerializable)in.readObject();
            this.memberListVersion = in.readInt();
        }
    }

    @Override
    public int getClassId() {
        return 6;
    }
}

