/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.ascii.AbstractTextCommandProcessor;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpBadRequestException;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpForbiddenException;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.ascii.rest.RestCallCollector;
import com.hazelcast.internal.ascii.rest.RestValue;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class HttpCommandProcessor<T extends HttpCommand>
extends AbstractTextCommandProcessor<T> {
    public static final String URI_MAPS = "/hazelcast/rest/maps/";
    public static final String URI_QUEUES = "/hazelcast/rest/queues/";
    public static final String URI_WAN_BASE_URL = "/hazelcast/rest/wan";
    public static final String URI_HEALTH_URL = "/hazelcast/health";
    public static final String URI_HEALTH_READY = "/hazelcast/health/ready";
    public static final String URI_INSTANCE = "/hazelcast/rest/instance";
    public static final String URI_CLUSTER = "/hazelcast/rest/cluster";
    public static final String URI_CLUSTER_MANAGEMENT_BASE_URL = "/hazelcast/rest/management/cluster";
    public static final String URI_CLUSTER_STATE_URL = "/hazelcast/rest/management/cluster/state";
    public static final String URI_CHANGE_CLUSTER_STATE_URL = "/hazelcast/rest/management/cluster/changeState";
    public static final String URI_CLUSTER_VERSION_URL = "/hazelcast/rest/management/cluster/version";
    public static final String URI_SHUTDOWN_CLUSTER_URL = "/hazelcast/rest/management/cluster/clusterShutdown";
    public static final String URI_SHUTDOWN_NODE_CLUSTER_URL = "/hazelcast/rest/management/cluster/memberShutdown";
    public static final String URI_CLUSTER_NODES_URL = "/hazelcast/rest/management/cluster/nodes";
    public static final String URI_FORCESTART_CLUSTER_URL = "/hazelcast/rest/management/cluster/forceStart";
    public static final String URI_PARTIALSTART_CLUSTER_URL = "/hazelcast/rest/management/cluster/partialStart";
    public static final String URI_PERSISTENCE_BACKUP_CLUSTER_URL = "/hazelcast/rest/management/cluster/backup";
    public static final String URI_PERSISTENCE_BACKUP_INTERRUPT_CLUSTER_URL = "/hazelcast/rest/management/cluster/backupInterrupt";
    public static final String URI_HOT_RESTART_BACKUP_CLUSTER_URL = "/hazelcast/rest/management/cluster/hotBackup";
    public static final String URI_HOT_RESTART_BACKUP_INTERRUPT_CLUSTER_URL = "/hazelcast/rest/management/cluster/hotBackupInterrupt";
    public static final String URI_WAN_SYNC_MAP = "/hazelcast/rest/wan/sync/map";
    public static final String URI_WAN_SYNC_ALL_MAPS = "/hazelcast/rest/wan/sync/allmaps";
    public static final String URI_WAN_SYNC_PROGRESS = "/hazelcast/rest/wan/sync/progress";
    public static final String URI_WAN_CLEAR_QUEUES = "/hazelcast/rest/wan/clearWanQueues";
    public static final String URI_ADD_WAN_CONFIG = "/hazelcast/rest/wan/addWanConfig";
    public static final String URI_WAN_PAUSE_PUBLISHER = "/hazelcast/rest/wan/pausePublisher";
    public static final String URI_WAN_STOP_PUBLISHER = "/hazelcast/rest/wan/stopPublisher";
    public static final String URI_WAN_RESUME_PUBLISHER = "/hazelcast/rest/wan/resumePublisher";
    public static final String URI_WAN_CONSISTENCY_CHECK_MAP = "/hazelcast/rest/wan/consistencyCheck/map";
    public static final String URI_LICENSE_INFO = "/hazelcast/rest/license";
    public static final String URI_CP_SUBSYSTEM_BASE_URL = "/hazelcast/rest/cp-subsystem";
    public static final String URI_RESET_CP_SUBSYSTEM_URL = "/hazelcast/rest/cp-subsystem/reset";
    public static final String URI_CP_GROUPS_URL = "/hazelcast/rest/cp-subsystem/groups";
    public static final String URI_CP_SESSIONS_SUFFIX = "/sessions";
    public static final String URI_REMOVE_SUFFIX = "/remove";
    public static final String URI_CP_MEMBERS_URL = "/hazelcast/rest/cp-subsystem/members";
    public static final String URI_LOCAL_CP_MEMBER_URL = "/hazelcast/rest/cp-subsystem/members/local";
    public static final String URI_LOG_LEVEL = "/hazelcast/rest/log-level";
    public static final String URI_LOG_LEVEL_RESET = "/hazelcast/rest/log-level/reset";
    public static final String URI_CONFIG = "/hazelcast/rest/config";
    public static final String URI_CONFIG_RELOAD = "/hazelcast/rest/config/reload";
    public static final String URI_CONFIG_UPDATE = "/hazelcast/rest/config/update";
    public static final String URI_TCP_IP_MEMBER_LIST = "/hazelcast/rest/config/tcp-ip/member-list";
    protected final ILogger logger;
    protected final RestCallCollector restCallCollector;
    protected final Executor internalAsyncExecutor;

    protected HttpCommandProcessor(TextCommandService textCommandService, ILogger logger) {
        super(textCommandService);
        this.logger = logger;
        this.restCallCollector = textCommandService.getRestCallCollector();
        this.internalAsyncExecutor = this.getNode().getNodeEngine().getExecutionService().getExecutor("hz:async");
    }

    protected void prepareResponse(@Nonnull HttpCommand command, @Nullable Object value) {
        if (value == null) {
            command.send204();
        } else {
            this.prepareResponse(HttpStatusCode.SC_200, command, value);
        }
    }

    protected void prepareResponse(HttpStatusCode statusCode, @Nonnull HttpCommand command, @Nonnull Object value) {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            command.setResponse(statusCode, HttpCommand.CONTENT_TYPE_BINARY, bytes);
        } else if (value instanceof RestValue) {
            RestValue restValue = (RestValue)value;
            command.setResponse(statusCode, restValue.getContentType(), restValue.getValue());
        } else if (value instanceof HazelcastJsonValue || value instanceof JsonValue) {
            command.setResponse(statusCode, HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(value.toString()));
        } else if (value instanceof String) {
            String string = (String)value;
            command.setResponse(statusCode, HttpCommand.CONTENT_TYPE_PLAIN_TEXT, StringUtil.stringToBytes(string));
        } else {
            command.setResponse(statusCode, HttpCommand.CONTENT_TYPE_BINARY, this.textCommandService.toByteArray(value));
        }
    }

    @Nonnull
    private static String[] decodeParams(HttpPostCommand command, int expectedParamCount) {
        byte[] data = command.getData();
        if (data == null) {
            throw new HttpBadRequestException("This endpoint expects at least " + expectedParamCount + " parameters");
        }
        String[] encoded = new String(data, StandardCharsets.UTF_8).split("&", expectedParamCount);
        String[] decoded = new String[encoded.length];
        if (encoded.length < expectedParamCount) {
            throw new HttpBadRequestException("This endpoint expects at least " + expectedParamCount + " parameters");
        }
        for (int i = 0; i < expectedParamCount; ++i) {
            decoded[i] = URLDecoder.decode(encoded[i], StandardCharsets.UTF_8);
        }
        return decoded;
    }

    protected String[] decodeParamsAndAuthenticate(HttpPostCommand cmd, int expectedParamCount) {
        String[] params = HttpCommandProcessor.decodeParams(cmd, expectedParamCount);
        if (!this.authenticate(cmd, params[0], params[1])) {
            throw new HttpForbiddenException();
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate(@Nonnull HttpPostCommand command, @Nullable String userName, @Nullable String pass) {
        String decodedName = userName != null ? URLDecoder.decode(userName, StandardCharsets.UTF_8) : null;
        SecurityContext securityContext = this.getNode().getNodeExtension().getSecurityContext();
        String clusterName = this.getNode().getConfig().getClusterName();
        if (securityContext == null) {
            if (pass != null && !pass.isEmpty()) {
                this.logger.fine("Password was provided but the Hazelcast Security is disabled.");
            }
            return clusterName.equals(decodedName);
        }
        String decodedPass = pass != null ? URLDecoder.decode(pass, StandardCharsets.UTF_8) : null;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(decodedName, decodedPass);
        Boolean passed = Boolean.FALSE;
        try {
            LoginContext lc = securityContext.createMemberLoginContext(decodedName, credentials, command.getConnection());
            lc.login();
            passed = Boolean.TRUE;
        }
        catch (LoginException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.textCommandService.getNode().getNodeExtension().getAuditlogService().eventBuilder("HZ-0503").message("REST connection authentication.").addParameter("user", userName).addParameter("command", command).addParameter("passed", passed).log();
        }
        return true;
    }

    protected void sendResponse(HttpPostCommand command, JsonObject json) {
        this.prepareResponse(command, json);
        this.textCommandService.sendResponse(command);
    }

    protected static JsonObject exceptionResponse(Throwable throwable) {
        return HttpCommandProcessor.response(ResponseType.FAIL, "message", throwable.getMessage());
    }

    protected static JsonObject response(ResponseType type, String ... attributes) {
        JsonObject object = new JsonObject().add("status", type.toString());
        if (attributes.length > 0) {
            int i = 0;
            while (i < attributes.length) {
                String value;
                String key = attributes[i++];
                if ((value = attributes[i++]) == null) continue;
                object.add(key, value);
            }
        }
        return object;
    }

    protected Node getNode() {
        return this.textCommandService.getNode();
    }

    protected static enum ResponseType {
        SUCCESS,
        FAIL;


        public String toString() {
            return super.toString().toLowerCase(StringUtil.LOCALE_INTERNAL);
        }
    }
}

