/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnectionBase;
import com.hazelcast.dataconnection.DataConnectionResource;
import com.hazelcast.dataconnection.impl.hazelcastdataconnection.HazelcastDataConnectionClientConfigBuilder;
import com.hazelcast.dataconnection.impl.hazelcastdataconnection.HazelcastDataConnectionConfigLoader;
import com.hazelcast.dataconnection.impl.hazelcastdataconnection.HazelcastDataConnectionConfigValidator;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.map.IMap;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class HazelcastDataConnection
extends DataConnectionBase {
    public static final String CLIENT_XML = "client_xml";
    public static final String CLIENT_YML = "client_yml";
    public static final String CLIENT_XML_PATH = "client_xml_path";
    public static final String CLIENT_YML_PATH = "client_yml_path";
    public static final String OBJECT_TYPE_IMAP_JOURNAL = "IMapJournal";
    private final ClientConfig clientConfig = this.buildClientConfig();
    private ConcurrentMemoizingSupplier<HazelcastClientProxy> proxy;

    public HazelcastDataConnection(@Nonnull DataConnectionConfig dataConnectionConfig) {
        super(dataConnectionConfig);
        if (dataConnectionConfig.isShared()) {
            this.proxy = new ConcurrentMemoizingSupplier<HazelcastClientProxy>(() -> {
                HazelcastClientProxy hazelcastClientProxy = (HazelcastClientProxy)HazelcastClient.newHazelcastClient(this.clientConfig);
                return new HazelcastClientProxy(hazelcastClientProxy.client){

                    @Override
                    public void shutdown() {
                        HazelcastDataConnection.this.release();
                    }
                };
            });
        }
    }

    private ClientConfig buildClientConfig() {
        this.validateConfiguration();
        HazelcastDataConnectionConfigLoader configLoader = new HazelcastDataConnectionConfigLoader();
        DataConnectionConfig dataConnectionConfig = configLoader.load(this.getConfig());
        HazelcastDataConnectionClientConfigBuilder configBuilder = new HazelcastDataConnectionClientConfigBuilder();
        return configBuilder.buildClientConfig(dataConnectionConfig);
    }

    private void validateConfiguration() {
        HazelcastDataConnectionConfigValidator validator = new HazelcastDataConnectionConfigValidator();
        DataConnectionConfig dataConnectionConfig = this.getConfig();
        validator.validate(dataConnectionConfig);
    }

    @Override
    @Nonnull
    public Collection<String> resourceTypes() {
        return Collections.singleton(OBJECT_TYPE_IMAP_JOURNAL);
    }

    @Override
    @Nonnull
    public Collection<DataConnectionResource> listResources() {
        HazelcastInstance instance = this.getClient();
        try {
            Collection collection = instance.getDistributedObjects().stream().filter(IMap.class::isInstance).map(o -> new DataConnectionResource(OBJECT_TYPE_IMAP_JOURNAL, o.getName())).collect(Collectors.toList());
            return collection;
        }
        finally {
            instance.shutdown();
        }
    }

    @Nonnull
    public HazelcastInstance getClient() {
        if (this.getConfig().isShared()) {
            this.retain();
            return this.proxy.get();
        }
        return HazelcastClient.newHazelcastClient(this.clientConfig);
    }

    @Override
    public synchronized void destroy() {
        if (this.proxy != null) {
            HazelcastClientProxy rememberedProxy = this.proxy.remembered();
            if (rememberedProxy != null) {
                rememberedProxy.client.shutdown();
            }
            this.proxy = null;
        }
    }
}

