/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AwsConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AzureConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.DiscoveryConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EurekaConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.GcpConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.KubernetesConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanSyncConfigCodec;
import com.hazelcast.client.impl.protocol.codec.holder.DiscoveryConfigHolder;
import com.hazelcast.client.impl.protocol.codec.holder.WanBatchPublisherConfigHolder;
import com.hazelcast.client.impl.protocol.codec.holder.WanSyncConfigHolder;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.internal.serialization.Data;
import java.util.Map;

public final class WanBatchPublisherConfigHolderCodec {
    private static final int SNAPSHOT_ENABLED_FIELD_OFFSET = 0;
    private static final int INITIAL_PUBLISHER_STATE_FIELD_OFFSET = 1;
    private static final int QUEUE_CAPACITY_FIELD_OFFSET = 2;
    private static final int BATCH_SIZE_FIELD_OFFSET = 6;
    private static final int BATCH_MAX_DELAY_MILLIS_FIELD_OFFSET = 10;
    private static final int RESPONSE_TIMEOUT_MILLIS_FIELD_OFFSET = 14;
    private static final int QUEUE_FULL_BEHAVIOR_FIELD_OFFSET = 18;
    private static final int ACKNOWLEDGE_TYPE_FIELD_OFFSET = 22;
    private static final int DISCOVERY_PERIOD_SECONDS_FIELD_OFFSET = 26;
    private static final int MAX_TARGET_ENDPOINTS_FIELD_OFFSET = 30;
    private static final int MAX_CONCURRENT_INVOCATIONS_FIELD_OFFSET = 34;
    private static final int USE_ENDPOINT_PRIVATE_ADDRESS_FIELD_OFFSET = 38;
    private static final int IDLE_MIN_PARK_NS_FIELD_OFFSET = 39;
    private static final int IDLE_MAX_PARK_NS_FIELD_OFFSET = 47;
    private static final int INITIAL_FRAME_SIZE = 55;

    private WanBatchPublisherConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, WanBatchPublisherConfigHolder wanBatchPublisherConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[55]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, wanBatchPublisherConfigHolder.isSnapshotEnabled());
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 1, wanBatchPublisherConfigHolder.getInitialPublisherState());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 2, wanBatchPublisherConfigHolder.getQueueCapacity());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 6, wanBatchPublisherConfigHolder.getBatchSize());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 10, wanBatchPublisherConfigHolder.getBatchMaxDelayMillis());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 14, wanBatchPublisherConfigHolder.getResponseTimeoutMillis());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 18, wanBatchPublisherConfigHolder.getQueueFullBehavior());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 22, wanBatchPublisherConfigHolder.getAcknowledgeType());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 26, wanBatchPublisherConfigHolder.getDiscoveryPeriodSeconds());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 30, wanBatchPublisherConfigHolder.getMaxTargetEndpoints());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 34, wanBatchPublisherConfigHolder.getMaxConcurrentInvocations());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 38, wanBatchPublisherConfigHolder.isUseEndpointPrivateAddress());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 39, wanBatchPublisherConfigHolder.getIdleMinParkNs());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 47, wanBatchPublisherConfigHolder.getIdleMaxParkNs());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, wanBatchPublisherConfigHolder.getPublisherId(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, wanBatchPublisherConfigHolder.getClassName(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, wanBatchPublisherConfigHolder.getImplementation(), DataCodec::encode);
        MapCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getProperties(), StringCodec::encode, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, wanBatchPublisherConfigHolder.getClusterName(), StringCodec::encode);
        StringCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getTargetEndpoints());
        AwsConfigCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getAwsConfig());
        GcpConfigCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getGcpConfig());
        AzureConfigCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getAzureConfig());
        KubernetesConfigCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getKubernetesConfig());
        EurekaConfigCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getEurekaConfig());
        DiscoveryConfigCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getDiscoveryConfig());
        WanSyncConfigCodec.encode(clientMessage, wanBatchPublisherConfigHolder.getSyncConfig());
        CodecUtil.encodeNullable(clientMessage, wanBatchPublisherConfigHolder.getEndpoint(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static WanBatchPublisherConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean snapshotEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        byte initialPublisherState = FixedSizeTypesCodec.decodeByte(initialFrame.content, 1);
        int queueCapacity = FixedSizeTypesCodec.decodeInt(initialFrame.content, 2);
        int batchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 6);
        int batchMaxDelayMillis = FixedSizeTypesCodec.decodeInt(initialFrame.content, 10);
        int responseTimeoutMillis = FixedSizeTypesCodec.decodeInt(initialFrame.content, 14);
        int queueFullBehavior = FixedSizeTypesCodec.decodeInt(initialFrame.content, 18);
        int acknowledgeType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 22);
        int discoveryPeriodSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 26);
        int maxTargetEndpoints = FixedSizeTypesCodec.decodeInt(initialFrame.content, 30);
        int maxConcurrentInvocations = FixedSizeTypesCodec.decodeInt(initialFrame.content, 34);
        boolean useEndpointPrivateAddress = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 38);
        long idleMinParkNs = FixedSizeTypesCodec.decodeLong(initialFrame.content, 39);
        long idleMaxParkNs = FixedSizeTypesCodec.decodeLong(initialFrame.content, 47);
        String publisherId = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        String className = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        Data implementation = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Map<String, Data> properties = MapCodec.decode(iterator, StringCodec::decode, DataCodec::decode);
        String clusterName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        String targetEndpoints = StringCodec.decode(iterator);
        AwsConfig awsConfig = AwsConfigCodec.decode(iterator);
        GcpConfig gcpConfig = GcpConfigCodec.decode(iterator);
        AzureConfig azureConfig = AzureConfigCodec.decode(iterator);
        KubernetesConfig kubernetesConfig = KubernetesConfigCodec.decode(iterator);
        EurekaConfig eurekaConfig = EurekaConfigCodec.decode(iterator);
        DiscoveryConfigHolder discoveryConfig = DiscoveryConfigCodec.decode(iterator);
        WanSyncConfigHolder syncConfig = WanSyncConfigCodec.decode(iterator);
        String endpoint = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new WanBatchPublisherConfigHolder(publisherId, className, implementation, properties, clusterName, snapshotEnabled, initialPublisherState, queueCapacity, batchSize, batchMaxDelayMillis, responseTimeoutMillis, queueFullBehavior, acknowledgeType, discoveryPeriodSeconds, maxTargetEndpoints, maxConcurrentInvocations, useEndpointPrivateAddress, idleMinParkNs, idleMaxParkNs, targetEndpoints, awsConfig, gcpConfig, azureConfig, kubernetesConfig, eurekaConfig, discoveryConfig, syncConfig, endpoint);
    }
}

