/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.cp.internal.RaftGroupId;

public final class CPGroupIdCodec {
    private static final int SEED_FIELD_OFFSET = 0;
    private static final int ID_FIELD_OFFSET = 8;
    private static final int INITIAL_FRAME_SIZE = 16;

    private CPGroupIdCodec() {
    }

    public static void encode(ClientMessage clientMessage, RaftGroupId cPGroupId) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, cPGroupId.getSeed());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 8, cPGroupId.getId());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, cPGroupId.getName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static RaftGroupId decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        long seed = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        long id = FixedSizeTypesCodec.decodeLong(initialFrame.content, 8);
        String name = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new RaftGroupId(name, seed, id);
    }
}

