/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ListLongCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SchemaCodec;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class EntryListLongSchemaCodec {
    private EntryListLongSchemaCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<Long, Schema>> collection) {
        ArrayList<Long> valueList = new ArrayList<Long>(collection.size());
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (Map.Entry<Long, Schema> entry : collection) {
            valueList.add(entry.getKey());
            SchemaCodec.encode(clientMessage, entry.getValue());
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
        ListLongCodec.encode(clientMessage, valueList);
    }

    public static List<Map.Entry<Long, Schema>> decode(ClientMessage.ForwardFrameIterator iterator) {
        List<Schema> listV = ListMultiFrameCodec.decode(iterator, SchemaCodec::decode);
        List<Long> listK = ListLongCodec.decode(iterator);
        ArrayList<Map.Entry<Long, Schema>> result = new ArrayList<Map.Entry<Long, Schema>>(listK.size());
        for (int i = 0; i < listK.size(); ++i) {
            result.add(new AbstractMap.SimpleEntry<Long, Schema>(listK.get(i), listV.get(i)));
        }
        return result;
    }
}

