/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListUUIDListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListUUIDCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemberInfoCodec;
import com.hazelcast.client.impl.protocol.codec.custom.VersionCodec;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.logging.Logger;
import com.hazelcast.version.Version;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ClientAddClusterViewListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 768;
    public static final int RESPONSE_MESSAGE_TYPE = 769;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;
    private static final int EVENT_MEMBERS_VIEW_VERSION_FIELD_OFFSET = 16;
    private static final int EVENT_MEMBERS_VIEW_INITIAL_FRAME_SIZE = 20;
    private static final int EVENT_MEMBERS_VIEW_MESSAGE_TYPE = 770;
    private static final int EVENT_PARTITIONS_VIEW_VERSION_FIELD_OFFSET = 16;
    private static final int EVENT_PARTITIONS_VIEW_INITIAL_FRAME_SIZE = 20;
    private static final int EVENT_PARTITIONS_VIEW_MESSAGE_TYPE = 771;
    private static final int EVENT_MEMBER_GROUPS_VIEW_VERSION_FIELD_OFFSET = 16;
    private static final int EVENT_MEMBER_GROUPS_VIEW_INITIAL_FRAME_SIZE = 20;
    private static final int EVENT_MEMBER_GROUPS_VIEW_MESSAGE_TYPE = 772;
    private static final int EVENT_CLUSTER_VERSION_INITIAL_FRAME_SIZE = 16;
    private static final int EVENT_CLUSTER_VERSION_MESSAGE_TYPE = 773;

    private ClientAddClusterViewListenerCodec() {
    }

    public static ClientMessage encodeRequest() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Client.AddClusterViewListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 768);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 769);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ClientMessage encodeMembersViewEvent(int version, Collection<MemberInfo> memberInfos) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 770);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, version);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, memberInfos, MemberInfoCodec::encode);
        return clientMessage;
    }

    public static ClientMessage encodePartitionsViewEvent(int version, Collection<Map.Entry<UUID, List<Integer>>> partitions) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 771);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, version);
        clientMessage.add(initialFrame);
        EntryListUUIDListIntegerCodec.encode(clientMessage, partitions);
        return clientMessage;
    }

    public static ClientMessage encodeMemberGroupsViewEvent(int version, Collection<Collection<UUID>> memberGroups) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 772);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, version);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, memberGroups, ListUUIDCodec::encode);
        return clientMessage;
    }

    public static ClientMessage encodeClusterVersionEvent(Version version) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 773);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        VersionCodec.encode(clientMessage, version);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 770) {
                ClientMessage.Frame initialFrame = iterator.next();
                int version = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                List<MemberInfo> memberInfos = ListMultiFrameCodec.decode(iterator, MemberInfoCodec::decode);
                this.handleMembersViewEvent(version, memberInfos);
                return;
            }
            if (messageType == 771) {
                ClientMessage.Frame initialFrame = iterator.next();
                int version = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                List<Map.Entry<UUID, List<Integer>>> partitions = EntryListUUIDListIntegerCodec.decode(iterator);
                this.handlePartitionsViewEvent(version, partitions);
                return;
            }
            if (messageType == 772) {
                ClientMessage.Frame initialFrame = iterator.next();
                int version = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                List<Collection<UUID>> memberGroups = ListMultiFrameCodec.decode(iterator, ListUUIDCodec::decode);
                this.handleMemberGroupsViewEvent(version, memberGroups);
                return;
            }
            if (messageType == 773) {
                iterator.next();
                Version version = VersionCodec.decode(iterator);
                this.handleClusterVersionEvent(version);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleMembersViewEvent(int var1, Collection<MemberInfo> var2);

        public abstract void handlePartitionsViewEvent(int var1, Collection<Map.Entry<UUID, List<Integer>>> var2);

        public abstract void handleMemberGroupsViewEvent(int var1, Collection<Collection<UUID>> var2);

        public abstract void handleClusterVersionEvent(Version var1);
    }
}

