/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.TpcToken;
import com.hazelcast.client.impl.connection.tcp.RoutingMode;
import com.hazelcast.client.impl.statistics.ClientStatistics;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.internal.metrics.MetricConsumer;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.xa.XATransactionContextImpl;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class ClientEndpointImpl
implements ClientEndpoint {
    private static final String METRICS_TAG_CLIENT = "client";
    private static final String METRICS_TAG_TIMESTAMP = "timestamp";
    private static final String METRICS_TAG_CLIENTNAME = "clientname";
    private final ClientEngine clientEngine;
    private final ILogger logger;
    private final NodeEngine nodeEngine;
    private final ServerConnection connection;
    private final ConcurrentMap<UUID, TransactionContext> transactionContextMap = new ConcurrentHashMap<UUID, TransactionContext>();
    private final ConcurrentMap<UUID, Callable> removeListenerActions = new ConcurrentHashMap<UUID, Callable>();
    private final SocketAddress socketAddress;
    private final long creationTime;
    private LoginContext loginContext;
    private UUID clientUuid;
    private Credentials credentials;
    private volatile boolean authenticated;
    private String clientVersion;
    private Boolean enterprise;
    private final AtomicReference<ClientStatistics> statsRef = new AtomicReference();
    private String clientName;
    private Set<String> labels;
    private volatile boolean destroyed;
    private volatile TpcToken tpcToken;
    private RoutingMode routingMode;
    private boolean cpDirectToLeaderRouting;

    public ClientEndpointImpl(ClientEngine clientEngine, NodeEngine nodeEngine, ServerConnection connection) {
        this.clientEngine = clientEngine;
        this.logger = clientEngine.getLogger(this.getClass());
        this.nodeEngine = nodeEngine;
        this.connection = connection;
        this.socketAddress = connection.getRemoteSocketAddress();
        this.clientVersion = "Unknown";
        this.enterprise = false;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public ServerConnection getConnection() {
        return this.connection;
    }

    @Override
    public long getConnectionStartTime() {
        return this.connection.getStartTime();
    }

    @Override
    public UUID getUuid() {
        return this.clientUuid;
    }

    @Override
    public boolean isAlive() {
        return this.connection.isAlive();
    }

    @Override
    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    @Override
    public Subject getSubject() {
        return this.loginContext != null ? this.loginContext.getSubject() : null;
    }

    @Override
    public void authenticated(UUID clientUuid, Credentials credentials, String clientVersion, long authCorrelationId, String clientName, Set<String> labels, RoutingMode routingMode, boolean cpDirectToLeaderRouting) {
        this.clientUuid = clientUuid;
        this.credentials = credentials;
        this.authenticated = true;
        this.setClientVersion(clientVersion);
        this.routingMode = routingMode;
        this.clientName = clientName;
        this.labels = labels;
        this.cpDirectToLeaderRouting = cpDirectToLeaderRouting;
        this.clientEngine.onEndpointAuthenticated(this);
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void setClientVersion(String version) {
        this.clientVersion = version;
    }

    @Override
    public boolean isEnterprise() {
        return this.enterprise;
    }

    @Override
    public void setEnterprise(Boolean enterprise) {
        this.enterprise = enterprise;
    }

    @Override
    public void setClientStatistics(ClientStatistics stats) {
        String clientAttributes;
        boolean setBefore;
        boolean bl = setBefore = this.getClientStatistics() != null;
        if (!setBefore && (clientAttributes = stats.clientAttributes()).contains("enterprise=true")) {
            this.setEnterprise(true);
        }
        this.statsRef.set(stats);
    }

    @Override
    public String getClientAttributes() {
        ClientStatistics statistics = this.statsRef.get();
        return statistics != null ? statistics.clientAttributes() : null;
    }

    @Override
    public ClientStatistics getClientStatistics() {
        return this.statsRef.get();
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.socketAddress;
    }

    @Override
    public String getClientType() {
        return this.connection.getConnectionType();
    }

    @Override
    public String getName() {
        return this.clientName;
    }

    @Override
    public Set<String> getLabels() {
        return this.labels;
    }

    @Override
    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    @Override
    public TransactionContext getTransactionContext(UUID txnId) {
        TransactionContext transactionContext = (TransactionContext)this.transactionContextMap.get(txnId);
        if (transactionContext == null) {
            throw new TransactionException("No transaction context found for txnId:" + txnId);
        }
        return transactionContext;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContextMap.put(transactionContext.getTxnId(), transactionContext);
        if (this.destroyed) {
            this.removedAndRollbackTransactionContext(transactionContext.getTxnId());
        }
    }

    @Override
    public void removeTransactionContext(UUID txnId) {
        this.transactionContextMap.remove(txnId);
    }

    @Override
    public void addListenerDestroyAction(String service, String topic, UUID id) {
        EventService eventService = this.clientEngine.getEventService();
        this.addDestroyAction(id, () -> eventService.deregisterListener(service, topic, id));
    }

    @Override
    public void addDestroyAction(UUID registrationId, Callable<Boolean> removeAction) {
        this.removeListenerActions.put(registrationId, removeAction);
        if (this.destroyed) {
            this.removeAndCallRemoveAction(registrationId);
        }
    }

    @Override
    public boolean removeDestroyAction(UUID id) {
        return this.removeListenerActions.remove(id) != null;
    }

    public void destroy() throws LoginException {
        this.destroyed = true;
        this.nodeEngine.onClientDisconnected(this.getUuid());
        for (UUID registrationId : this.removeListenerActions.keySet()) {
            this.removeAndCallRemoveAction(registrationId);
        }
        for (UUID txnId : this.transactionContextMap.keySet()) {
            this.removedAndRollbackTransactionContext(txnId);
        }
        try {
            LoginContext lc = this.loginContext;
            if (lc != null) {
                lc.logout();
            }
        }
        finally {
            this.clientEngine.onEndpointDestroyed(this);
            this.authenticated = false;
        }
    }

    private void removeAndCallRemoveAction(UUID uuid) {
        Callable callable = (Callable)this.removeListenerActions.remove(uuid);
        if (callable != null) {
            try {
                callable.call();
            }
            catch (Exception e) {
                this.logger.warning("Exception during remove listener action", e);
            }
        }
    }

    private void removedAndRollbackTransactionContext(UUID txnId) {
        TransactionContext context = (TransactionContext)this.transactionContextMap.remove(txnId);
        if (context != null) {
            if (context instanceof XATransactionContextImpl) {
                return;
            }
            try {
                context.rollbackTransaction();
            }
            catch (HazelcastInstanceNotActiveException e) {
                this.logger.finest(e);
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
    }

    public String toString() {
        return "ClientEndpoint{connection=" + this.connection + ", clientUuid=" + this.clientUuid + ", clientName=" + this.clientName + ", authenticated=" + this.authenticated + ", clientVersion=" + this.clientVersion + ", creationTime=" + this.creationTime + ", latest clientAttributes=" + this.getClientAttributes() + ", labels=" + this.labels + "}";
    }

    @Override
    public String toSecureString() {
        return "ClientEndpoint{clientUuid=" + this.clientUuid + ", clientName=" + this.clientName + ", clientVersion=" + this.clientVersion + ", labels=" + this.labels + "}";
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, final MetricsCollectionContext context) {
        ClientStatistics clientStatistics = this.statsRef.get();
        if (clientStatistics != null && clientStatistics.metricsBlob() != null) {
            byte[] metricsBlob = clientStatistics.metricsBlob();
            if (metricsBlob.length == 0) {
                return;
            }
            final long timestamp = clientStatistics.timestamp();
            MetricConsumer consumer = new MetricConsumer(){

                @Override
                public void consumeLong(MetricDescriptor descriptor, long value) {
                    context.collect(this.enhanceDescriptor(descriptor, timestamp), value);
                }

                @Override
                public void consumeDouble(MetricDescriptor descriptor, double value) {
                    context.collect(this.enhanceDescriptor(descriptor, timestamp), value);
                }

                private MetricDescriptor enhanceDescriptor(MetricDescriptor descriptor, long timestamp2) {
                    return descriptor.withExcludedTargets(MetricTarget.ALL_TARGETS).withIncludedTarget(MetricTarget.MANAGEMENT_CENTER).withTag(ClientEndpointImpl.METRICS_TAG_CLIENT, ClientEndpointImpl.this.getUuid().toString()).withTag(ClientEndpointImpl.METRICS_TAG_CLIENTNAME, ClientEndpointImpl.this.clientName).withTag(ClientEndpointImpl.METRICS_TAG_TIMESTAMP, Long.toString(timestamp2));
                }
            };
            MetricsCompressor.extractMetrics(metricsBlob, consumer);
        }
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setTpcToken(@Nonnull TpcToken tpcToken) {
        this.tpcToken = tpcToken;
    }

    @Override
    @Nullable
    public TpcToken getTpcToken() {
        return this.tpcToken;
    }

    @Override
    public boolean isCpDirectToLeaderEnabled() {
        return this.cpDirectToLeaderRouting;
    }
}

