/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheRSMutationObserver;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;

public class EventJournalRSMutationObserver
implements CacheRSMutationObserver {
    private final EventJournalConfig eventJournalConfig;
    private final ObjectNamespace objectNamespace;
    private final AbstractCacheService cacheService;
    private final int partitionId;

    public EventJournalRSMutationObserver(AbstractCacheService cacheService, EventJournalConfig eventJournalConfig, ObjectNamespace objectNamespace, int partitionId) {
        this.eventJournalConfig = eventJournalConfig;
        this.objectNamespace = objectNamespace;
        this.cacheService = cacheService;
        this.partitionId = partitionId;
    }

    @Override
    public void onCreate(Data key, Object value) {
        this.cacheService.eventJournal.writeCreatedEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, value);
    }

    @Override
    public void onRemove(Data key, Object value) {
        this.cacheService.eventJournal.writeRemoveEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, value);
    }

    @Override
    public void onUpdate(Data key, Object oldValue, Object value) {
        this.cacheService.eventJournal.writeUpdateEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, oldValue, value);
    }

    @Override
    public void onEvict(Data key, Object value) {
        this.cacheService.eventJournal.writeEvictEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, value);
    }

    @Override
    public void onExpire(Data key, Object value) {
        this.cacheService.eventJournal.writeExpiredEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, value);
    }

    @Override
    public void onDestroy() {
        this.cacheService.eventJournal.destroy(this.objectNamespace, this.partitionId);
    }
}

