/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsClient;
import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsCredentialsProvider;
import com.hazelcast.aws.AwsEc2Api;
import com.hazelcast.aws.AwsEc2Client;
import com.hazelcast.aws.AwsEcsApi;
import com.hazelcast.aws.AwsEcsClient;
import com.hazelcast.aws.AwsMetadataApi;
import com.hazelcast.aws.AwsRequestSigner;
import com.hazelcast.aws.Environment;
import com.hazelcast.aws.RegionValidator;
import com.hazelcast.aws.Tag;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class AwsClientConfigurator {
    private static final ILogger LOGGER = Logger.getLogger(AwsClientConfigurator.class);
    private static final String DEFAULT_EC2_HOST_HEADER = "ec2.amazonaws.com";
    private static final String DEFAULT_ECS_HOST_HEADER = "ecs.amazonaws.com";
    private static final String EC2_SERVICE_NAME = "ec2";
    private static final String ECS_SERVICE_NAME = "ecs";

    private AwsClientConfigurator() {
    }

    static AwsClient createAwsClient(AwsConfig awsConfig) {
        Environment environment = new Environment();
        AwsMetadataApi metadataApi = new AwsMetadataApi(awsConfig);
        String region = AwsClientConfigurator.resolveRegion(awsConfig, metadataApi, environment);
        RegionValidator.validateRegion(region);
        AwsCredentialsProvider credentialsProvider = new AwsCredentialsProvider(awsConfig, metadataApi, environment);
        AwsEc2Api ec2Api = AwsClientConfigurator.createEc2Api(awsConfig, region);
        AwsEcsApi ecsApi = AwsClientConfigurator.createEcsApi(awsConfig, region);
        if (AwsClientConfigurator.explicitlyEc2Configured(awsConfig) || !AwsClientConfigurator.explicitlyEcsConfigured(awsConfig) && !environment.isRunningOnEcs()) {
            AwsClientConfigurator.logEc2Environment(awsConfig, region);
            return new AwsEc2Client(ec2Api, ecsApi, metadataApi, credentialsProvider, awsConfig);
        }
        String cluster = AwsClientConfigurator.resolveCluster(awsConfig, metadataApi, environment);
        AwsClientConfigurator.logEcsEnvironment(awsConfig, region, cluster);
        return new AwsEcsClient(cluster, awsConfig, ecsApi, ec2Api, metadataApi, credentialsProvider);
    }

    static String resolveRegion(AwsConfig awsConfig, AwsMetadataApi metadataApi, Environment environment) {
        if (!StringUtil.isNullOrEmptyAfterTrim(awsConfig.getRegion())) {
            return awsConfig.getRegion();
        }
        if (environment.isRunningOnEcs()) {
            return AwsClientConfigurator.regionFrom(metadataApi.availabilityZoneEcs());
        }
        return AwsClientConfigurator.regionFrom(metadataApi.availabilityZoneEc2());
    }

    private static String regionFrom(String availabilityZone) {
        return availabilityZone.substring(0, availabilityZone.length() - 1);
    }

    private static AwsEc2Api createEc2Api(AwsConfig awsConfig, String region) {
        String ec2Endpoint = AwsClientConfigurator.resolveEc2Endpoint(awsConfig, region);
        AwsRequestSigner ec2RequestSigner = new AwsRequestSigner(region, EC2_SERVICE_NAME);
        return new AwsEc2Api(ec2Endpoint, awsConfig, ec2RequestSigner, Clock.systemUTC());
    }

    private static AwsEcsApi createEcsApi(AwsConfig awsConfig, String region) {
        String ecsEndpoint = AwsClientConfigurator.resolveEcsEndpoint(awsConfig, region);
        AwsRequestSigner ecsRequestSigner = new AwsRequestSigner(region, ECS_SERVICE_NAME);
        return new AwsEcsApi(ecsEndpoint, awsConfig, ecsRequestSigner, Clock.systemUTC());
    }

    static String resolveEc2Endpoint(AwsConfig awsConfig, String region) {
        String ec2HostHeader = awsConfig.getHostHeader();
        if (StringUtil.isNullOrEmptyAfterTrim(ec2HostHeader) || ec2HostHeader.startsWith(ECS_SERVICE_NAME) || ec2HostHeader.equals(EC2_SERVICE_NAME)) {
            ec2HostHeader = DEFAULT_EC2_HOST_HEADER;
        }
        return ec2HostHeader.replace("ec2.", "ec2." + region + ".");
    }

    static String resolveEcsEndpoint(AwsConfig awsConfig, String region) {
        String ecsHostHeader = awsConfig.getHostHeader();
        if (StringUtil.isNullOrEmptyAfterTrim(ecsHostHeader) || ecsHostHeader.equals(ECS_SERVICE_NAME)) {
            ecsHostHeader = DEFAULT_ECS_HOST_HEADER;
        }
        return ecsHostHeader.replace("ecs.", "ecs." + region + ".");
    }

    static boolean explicitlyEc2Configured(AwsConfig awsConfig) {
        return !StringUtil.isNullOrEmptyAfterTrim(awsConfig.getHostHeader()) && awsConfig.getHostHeader().startsWith(EC2_SERVICE_NAME);
    }

    static boolean explicitlyEcsConfigured(AwsConfig awsConfig) {
        return !StringUtil.isNullOrEmptyAfterTrim(awsConfig.getCluster()) || !StringUtil.isNullOrEmptyAfterTrim(awsConfig.getHostHeader()) && awsConfig.getHostHeader().startsWith(ECS_SERVICE_NAME);
    }

    static String resolveCluster(AwsConfig awsConfig, AwsMetadataApi metadataApi, Environment environment) {
        if (!StringUtil.isNullOrEmptyAfterTrim(awsConfig.getCluster())) {
            return awsConfig.getCluster();
        }
        if (environment.isRunningOnEcs()) {
            String cluster = metadataApi.clusterEcs();
            LOGGER.info("No ECS cluster defined, using current cluster: " + cluster);
            return cluster;
        }
        throw new InvalidConfigurationException("You must define 'cluster' property if not running inside ECS cluster");
    }

    private static void logEc2Environment(AwsConfig awsConfig, String region) {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("tag-key", AwsClientConfigurator.combineTagKeys(awsConfig.getTags()));
        filters.put("tag-value", AwsClientConfigurator.combineTagValues(awsConfig.getTags()));
        filters.put("security-group-name", awsConfig.getSecurityGroupName());
        filters.put("hz-port", awsConfig.getHzPort().toString());
        LOGGER.info(String.format("AWS plugin performing discovery in EC2 environment for region: '%s' filtered by: '%s'", region, AwsClientConfigurator.logFilters(filters)));
    }

    private static String combineTagKeys(List<Tag> tags) {
        return tags.stream().map(Tag::getKey).collect(Collectors.joining(","));
    }

    private static String combineTagValues(List<Tag> tags) {
        return tags.stream().map(Tag::getValue).collect(Collectors.joining(","));
    }

    private static void logEcsEnvironment(AwsConfig awsConfig, String region, String cluster) {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("family", awsConfig.getFamily());
        filters.put("service-name", awsConfig.getServiceName());
        filters.put("hz-port", awsConfig.getHzPort().toString());
        LOGGER.info(String.format("AWS plugin performing discovery in ECS environment for region: '%s' for cluster: '%s' filtered by: '%s'", region, cluster, AwsClientConfigurator.logFilters(filters)));
    }

    private static String logFilters(Map<String, String> parameters) {
        return parameters.entrySet().stream().filter(e -> e.getValue() != null).sorted(Map.Entry.comparingByKey()).map(e -> String.format("%s:%s", e.getKey(), e.getValue())).collect(Collectors.joining(", "));
    }
}

