/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.scheduling.util;

import com.github.caldav4j.exceptions.CalDAV4JException;
import java.util.Collection;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITipUtils {
    private static final Logger log = LoggerFactory.getLogger(ITipUtils.class);
    private static TimeZone J_TZ_GMT = TimeZone.getTimeZone("GMT");

    public static Calendar ReplyInvitation(Calendar invite, Attendee mySelf, PartStat replyPartStat) throws CalDAV4JException {
        return ITipUtils.ManageInvitation(invite, mySelf, Method.REPLY, replyPartStat);
    }

    public static Calendar ManageInvitation(Calendar invite, Attendee mySelf, Method responseMethod, PartStat responsePartStat) throws CalDAV4JException {
        try {
            Calendar reply = new Calendar(invite);
            if (reply.getProperty("METHOD") != null && ITipUtils.compareMethod(Method.REQUEST, reply.getMethod()) && ITipUtils.compareMethod(Method.REPLY, responseMethod)) {
                reply.getProperties().remove((Property)Method.REQUEST);
                reply.getProperties().add((Property)Method.REPLY);
                ITipUtils.processAttendees(reply, mySelf, responsePartStat);
            }
            return reply;
        }
        catch (Exception e) {
            log.warn("Calendar " + invite + "malformed");
            throw new CalDAV4JException("Calendar " + invite + "malformed", new Throwable("Bad calendar REQUEST"));
        }
    }

    private static boolean compareMethod(Method m, Method n) {
        try {
            return m.getValue().equals(n.getValue());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private static void processAttendees(Calendar c, Attendee user, PartStat action) throws CalDAV4JException {
        int numAttendees = 0;
        for (Object o : c.getComponents()) {
            if (o instanceof VTimeZone) continue;
            CalendarComponent cc = (CalendarComponent)o;
            PropertyList attendees = cc.getProperties("ATTENDEE");
            cc.getProperties().removeAll((Collection)attendees);
            while (attendees.size() > numAttendees) {
                Attendee a = (Attendee)attendees.get(numAttendees);
                if (!a.getValue().equals(user.getValue())) {
                    attendees.remove(numAttendees);
                    continue;
                }
                a.getParameters().remove(a.getParameter("PARTSTAT"));
                a.getParameters().add((Parameter)action);
                ++numAttendees;
            }
            cc.getProperties().addAll((Collection)attendees);
        }
        if (numAttendees < 1) {
            throw new CalDAV4JException("Attendee " + user + "not invited to event", new Throwable("Missing attendee"));
        }
    }
}

