/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;

public class CalendarRequest {
    private Calendar calendar = null;
    private Charset charset = null;
    private Set<String> etags = new HashSet<String>();
    private boolean ifMatch = false;
    private boolean ifNoneMatch = false;
    private boolean allEtags = false;

    public CalendarRequest() {
    }

    public CalendarRequest(Calendar calendar, Charset charset, Set<String> etags, boolean ifMatch, boolean ifNoneMatch, boolean allEtags) {
        this.calendar = calendar;
        this.etags = etags;
        this.ifMatch = ifMatch;
        this.ifNoneMatch = ifNoneMatch;
        this.allEtags = allEtags;
        this.charset = charset;
    }

    public CalendarRequest(Calendar calendar) {
        this.calendar = calendar;
    }

    public CalendarRequest(Calendar calendar, Set<String> etags, boolean ifMatch, boolean ifNoneMatch) {
        this.calendar = calendar;
        this.etags = etags;
        this.ifMatch = ifMatch;
        this.ifNoneMatch = ifNoneMatch;
    }

    public CalendarRequest(Calendar calendar, boolean ifMatch, boolean ifNoneMatch, boolean allEtags) {
        this.calendar = calendar;
        this.ifMatch = ifMatch;
        this.ifNoneMatch = ifNoneMatch;
        this.allEtags = allEtags;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public void setCalendar(VEvent vevent, VTimeZone vtimeZone, String prodId) {
        if (prodId == null) {
            prodId = "-//NONSGML CalDAV4j Client//EN";
        }
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)new ProdId(prodId));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        calendar.getComponents().add((Object)vevent);
        if (vtimeZone != null) {
            calendar.getComponents().add((Object)vtimeZone);
        }
        this.calendar = calendar;
    }

    public void setCalendar(VEvent event, String prodId) {
        this.setCalendar(event, null, prodId);
    }

    public void setCalendar(VEvent event) {
        this.setCalendar(event, null, null);
    }

    public Set<String> getEtags() {
        return this.etags;
    }

    public void setEtags(Set<String> etags) {
        this.etags = etags;
    }

    public void addEtag(String etag) {
        this.etags.add(etag);
    }

    public boolean isIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(boolean ifMatch) {
        this.ifMatch = ifMatch;
    }

    public boolean isIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public void setIfNoneMatch(boolean ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
    }

    public boolean isAllEtags() {
        return this.allEtags;
    }

    public void setAllEtags(boolean allEtags) {
        this.allEtags = allEtags;
    }

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = Charset.defaultCharset();
        }
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

