/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.methods;

import com.github.caldav4j.model.request.CalendarDescription;
import com.github.caldav4j.model.request.DisplayName;
import com.github.caldav4j.model.request.MkCalendar;
import com.github.caldav4j.model.request.Prop;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.XmlEntity;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;

public class HttpMkCalendarMethod
extends BaseDavRequest {
    protected MkCalendar mkCalendar = null;

    public HttpMkCalendarMethod(String uri) {
        super(URI.create(uri));
    }

    public HttpMkCalendarMethod(URI uri) {
        super(uri);
    }

    public HttpMkCalendarMethod(URI uri, MkCalendar m) throws IOException {
        super(uri);
        if (m != null) {
            this.mkCalendar = m;
        }
        this.processRequest();
    }

    public HttpMkCalendarMethod(String uri, MkCalendar m) throws IOException {
        this(URI.create(uri), m);
    }

    public HttpMkCalendarMethod(URI uri, String displayName, String description, String descriptionLang) throws IOException {
        super(uri);
        Prop p = new Prop();
        if (displayName != null) {
            p.add((XmlSerializable)new DisplayName(displayName));
        }
        if (description != null) {
            p.add((XmlSerializable)new CalendarDescription(description, descriptionLang));
        }
        this.mkCalendar = new MkCalendar(p);
        this.processRequest();
    }

    public HttpMkCalendarMethod(URI uri, String displayName, String description) throws IOException {
        this(uri, displayName, description, null);
    }

    public HttpMkCalendarMethod(String uri, String displayName, String description, String descriptionLang) throws IOException {
        this(URI.create(uri), displayName, description, descriptionLang);
    }

    public HttpMkCalendarMethod(String uri, String displayName, String description) throws IOException {
        this(uri, displayName, description, null);
    }

    private void processRequest() throws IOException {
        try {
            Document d = DomUtil.createDocument();
            d.appendChild(this.mkCalendar.toXml(d));
            this.setEntity(XmlEntity.create((Document)d));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getMethod() {
        return "MKCALENDAR";
    }

    public boolean succeeded(HttpResponse response) {
        return response.getStatusLine().getStatusCode() == 201;
    }
}

