/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.spinner;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.IJQueryCultureWidget;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.utils.LocaleUtils;
import org.wicketstuff.jquery.ui.JQueryUIBehavior;
import org.wicketstuff.jquery.ui.form.spinner.SpinnerAdapter;
import org.wicketstuff.jquery.ui.form.spinner.TimeSpinnerBehavior;

public class TimeSpinner
extends DateTextField
implements IJQueryCultureWidget {
    private static final long serialVersionUID = 1L;
    protected final Options options;

    public TimeSpinner(String id) {
        this(id, "h:mm aa", new Options());
    }

    public TimeSpinner(String id, Options options) {
        this(id, "h:mm aa", options);
    }

    public TimeSpinner(String id, String pattern) {
        this(id, pattern, new Options());
    }

    public TimeSpinner(String id, String pattern, Options options) {
        super(id, pattern);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public TimeSpinner(String id, Locale locale) {
        this(id, locale, new Options());
    }

    public TimeSpinner(String id, Locale locale, Options options) {
        this(id, LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm aa"), options.set("culture", (Object)Options.asString((String)LocaleUtils.getLangageCode((Locale)locale))));
    }

    public TimeSpinner(String id, IModel<Date> model) {
        this(id, model, "h:mm aa", new Options());
    }

    public TimeSpinner(String id, IModel<Date> model, Options options) {
        this(id, model, "h:mm aa", options);
    }

    public TimeSpinner(String id, IModel<Date> model, String pattern) {
        this(id, model, pattern, new Options());
    }

    public TimeSpinner(String id, IModel<Date> model, String pattern, Options options) {
        super(id, model, pattern);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public TimeSpinner(String id, IModel<Date> model, Locale locale) {
        this(id, model, locale, new Options());
    }

    public TimeSpinner(String id, IModel<Date> model, Locale locale, Options options) {
        this(id, model, LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm aa"), options.set("culture", (Object)Options.asString((String)LocaleUtils.getLangageCode((Locale)locale))));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setDisabled(!this.isEnabledInHierarchy());
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public final String getTextFormat() {
        return super.getTextFormat();
    }

    public String getModelObjectAsString() {
        Date date = (Date)this.getModelObject();
        if (date != null) {
            return new SimpleDateFormat(this.getTextFormat()).format(date);
        }
        return "";
    }

    public TimeSpinner setCulture(String culture) {
        this.options.set("culture", (Object)Options.asString((String)culture));
        return this;
    }

    public String getCulture() {
        return (String)this.options.get("culture");
    }

    private TimeSpinner setDisabled(boolean disabled) {
        this.options.set("disabled", (Object)disabled);
        return this;
    }

    public JQueryUIBehavior newWidgetBehavior(String selector) {
        return new TimeSpinnerBehavior(selector, new SpinnerAdapter(), this.options);
    }
}

