/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.button;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jquery.ui.form.button.AjaxButton;
import org.wicketstuff.jquery.ui.widget.dialog.AbstractDialog;
import org.wicketstuff.jquery.ui.widget.dialog.AbstractFormDialog;
import org.wicketstuff.jquery.ui.widget.dialog.DialogButton;
import org.wicketstuff.jquery.ui.widget.dialog.DialogIcon;
import org.wicketstuff.jquery.ui.widget.dialog.MessageFormDialog;

public abstract class ConfirmAjaxButton
extends GenericPanel<String> {
    private static final long serialVersionUID = 1L;
    static final DialogButton BTN_CANCEL = new DialogButton("CANCEL", AbstractDialog.LBL_CANCEL);
    static final DialogButton BTN_OK = new DialogButton("OK", (IModel)AbstractDialog.LBL_OK){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isIndicating() {
            return true;
        }
    };
    private final IModel<String> labelModel;
    private final IModel<String> titleModel;
    private AjaxButton button;
    private AbstractFormDialog<?> dialog;

    public ConfirmAjaxButton(String id, String label, String title, String message) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)label)), (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)));
    }

    public ConfirmAjaxButton(String id, IModel<String> label, IModel<String> title, IModel<String> message) {
        super(id, message);
        this.labelModel = label;
        this.titleModel = title;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.dialog = this.newDialog("dialog", this.titleModel, (IModel<String>)this.getModel());
        this.add(new Component[]{this.dialog});
        this.button = this.newAjaxButton("button", this.dialog);
        this.add(new Component[]{this.button});
        this.button.add(new Component[]{new Label("label", this.labelModel).setRenderBodyOnly(true)});
    }

    protected abstract void onError(AjaxRequestTarget var1);

    protected abstract void onSubmit(AjaxRequestTarget var1);

    protected void onDetach() {
        super.onDetach();
        this.labelModel.detach();
        this.titleModel.detach();
    }

    protected String getIcon() {
        return "ui-icon-alert";
    }

    protected AbstractFormDialog<?> newDialog(String id, IModel<String> title, IModel<String> message) {
        return new MessageFormDialog(id, title, message, Arrays.asList(BTN_OK, BTN_CANCEL), DialogIcon.WARN){
            private static final long serialVersionUID = 1L;

            @Override
            public DialogButton getSubmitButton() {
                return this.findButton("OK");
            }

            @Override
            public Form<?> getForm() {
                return Form.findForm((Component)ConfirmAjaxButton.this);
            }

            @Override
            protected void onError(AjaxRequestTarget target, DialogButton button) {
                super.close((IPartialPageRequestHandler)target, null);
                ConfirmAjaxButton.this.onError(target);
            }

            @Override
            protected void onSubmit(AjaxRequestTarget target, DialogButton button) {
                ConfirmAjaxButton.this.onSubmit(target);
            }
        };
    }

    protected AjaxButton newAjaxButton(String id, final AbstractDialog<?> dialog) {
        return new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onInitialize() {
                super.onInitialize();
                this.setDefaultFormProcessing(false);
            }

            @Override
            protected String getIcon() {
                return ConfirmAjaxButton.this.getIcon();
            }

            protected void onSubmit(AjaxRequestTarget target) {
                dialog.open((IPartialPageRequestHandler)target);
            }
        };
    }
}

