/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.URIs;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcWriter;
import org.netpreserve.jwarc.net.CaptureIndex;
import org.netpreserve.jwarc.net.WarcRenderer;

public class ScreenshotTool {
    public static void main(String[] args) throws Exception {
        List<Path> warcs = Stream.of(args).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        try (WarcWriter warcWriter = new WarcWriter(System.out);
             WarcRenderer renderer = new WarcRenderer(new CaptureIndex(warcs));){
            for (String arg : args) {
                try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                    for (WarcRecord record : reader) {
                        if (!ScreenshotTool.isNormalPage(record)) continue;
                        WarcCaptureRecord capture = (WarcCaptureRecord)record;
                        renderer.screenshot(capture.target(), capture.date(), warcWriter);
                    }
                }
            }
        }
    }

    private static boolean isNormalPage(WarcRecord record) throws IOException {
        if (!(record instanceof WarcResponse) && !(record instanceof WarcResource)) {
            return false;
        }
        WarcCaptureRecord capture = (WarcCaptureRecord)record;
        if (!URIs.hasHttpOrHttpsScheme(capture.target())) {
            return false;
        }
        try {
            if (!capture.payload().isPresent() || !capture.payload().get().type().base().equals(MediaType.HTML)) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return !(capture instanceof WarcResponse) || ((WarcResponse)capture).http().status() == 200;
    }
}

