/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.core.metrics;

import io.prometheus.metrics.config.MetricsProperties;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import io.prometheus.metrics.core.exemplars.ExemplarSampler;
import io.prometheus.metrics.core.exemplars.ExemplarSamplerConfig;
import io.prometheus.metrics.core.metrics.Buffer;
import io.prometheus.metrics.core.metrics.CKMSQuantiles;
import io.prometheus.metrics.core.metrics.SlidingWindow;
import io.prometheus.metrics.core.metrics.StatefulMetric;
import io.prometheus.metrics.model.snapshots.Exemplars;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.Quantile;
import io.prometheus.metrics.model.snapshots.Quantiles;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nullable;

public class Summary
extends StatefulMetric<DistributionDataPoint, DataPoint>
implements DistributionDataPoint {
    private final List<CKMSQuantiles.Quantile> quantiles;
    private final long maxAgeSeconds;
    private final int ageBuckets;
    @Nullable
    private final ExemplarSamplerConfig exemplarSamplerConfig;

    private Summary(Builder builder, PrometheusProperties prometheusProperties) {
        super(builder);
        MetricsProperties[] properties = this.getMetricProperties(builder, prometheusProperties);
        this.quantiles = Collections.unmodifiableList(this.makeQuantiles(properties));
        this.maxAgeSeconds = this.getConfigProperty(properties, MetricsProperties::getSummaryMaxAgeSeconds);
        this.ageBuckets = this.getConfigProperty(properties, MetricsProperties::getSummaryNumberOfAgeBuckets);
        boolean exemplarsEnabled = this.getConfigProperty(properties, MetricsProperties::getExemplarsEnabled);
        this.exemplarSamplerConfig = exemplarsEnabled ? new ExemplarSamplerConfig(prometheusProperties.getExemplarProperties(), 4) : null;
    }

    private List<CKMSQuantiles.Quantile> makeQuantiles(MetricsProperties[] properties) {
        ArrayList<CKMSQuantiles.Quantile> result = new ArrayList<CKMSQuantiles.Quantile>();
        List quantiles = this.getConfigProperty(properties, MetricsProperties::getSummaryQuantiles);
        List quantileErrors = this.getConfigProperty(properties, MetricsProperties::getSummaryQuantileErrors);
        if (quantiles != null) {
            for (int i = 0; i < quantiles.size(); ++i) {
                if (quantileErrors.size() > 0) {
                    result.add(new CKMSQuantiles.Quantile((Double)quantiles.get(i), (Double)quantileErrors.get(i)));
                    continue;
                }
                result.add(new CKMSQuantiles.Quantile((Double)quantiles.get(i), Builder.defaultError((Double)quantiles.get(i))));
            }
        }
        return result;
    }

    @Override
    public void observe(double amount) {
        ((DataPoint)this.getNoLabels()).observe(amount);
    }

    @Override
    public void observeWithExemplar(double amount, Labels labels) {
        ((DataPoint)this.getNoLabels()).observeWithExemplar(amount, labels);
    }

    public SummarySnapshot collect() {
        return (SummarySnapshot)super.collect();
    }

    protected SummarySnapshot collect(List<Labels> labels, List<DataPoint> metricData) {
        ArrayList<SummarySnapshot.SummaryDataPointSnapshot> data = new ArrayList<SummarySnapshot.SummaryDataPointSnapshot>(labels.size());
        for (int i = 0; i < labels.size(); ++i) {
            data.add(metricData.get(i).collect(labels.get(i)));
        }
        return new SummarySnapshot(this.getMetadata(), data);
    }

    @Override
    protected DataPoint newDataPoint() {
        return new DataPoint();
    }

    public static Builder builder() {
        return new Builder(PrometheusProperties.get());
    }

    public static Builder builder(PrometheusProperties config) {
        return new Builder(config);
    }

    public static class Builder
    extends StatefulMetric.Builder<Builder, Summary> {
        public static final long DEFAULT_MAX_AGE_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
        public static final int DEFAULT_NUMBER_OF_AGE_BUCKETS = 5;
        private final List<CKMSQuantiles.Quantile> quantiles = new ArrayList<CKMSQuantiles.Quantile>();
        @Nullable
        private Long maxAgeSeconds;
        @Nullable
        private Integer ageBuckets;

        private Builder(PrometheusProperties properties) {
            super(Collections.singletonList("quantile"), properties);
        }

        private static double defaultError(double quantile) {
            if (quantile <= 0.01 || quantile >= 0.99) {
                return 0.001;
            }
            if (quantile <= 0.02 || quantile >= 0.98) {
                return 0.005;
            }
            return 0.01;
        }

        public Builder quantile(double quantile) {
            return this.quantile(quantile, Builder.defaultError(quantile));
        }

        public Builder quantile(double quantile, double error) {
            if (quantile < 0.0 || quantile > 1.0) {
                throw new IllegalArgumentException("Quantile " + quantile + " invalid: Expected number between 0.0 and 1.0.");
            }
            if (error < 0.0 || error > 1.0) {
                throw new IllegalArgumentException("Error " + error + " invalid: Expected number between 0.0 and 1.0.");
            }
            this.quantiles.add(new CKMSQuantiles.Quantile(quantile, error));
            return this;
        }

        public Builder maxAgeSeconds(long maxAgeSeconds) {
            if (maxAgeSeconds <= 0L) {
                throw new IllegalArgumentException("maxAgeSeconds cannot be " + maxAgeSeconds);
            }
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public Builder numberOfAgeBuckets(int ageBuckets) {
            if (ageBuckets <= 0) {
                throw new IllegalArgumentException("ageBuckets cannot be " + ageBuckets);
            }
            this.ageBuckets = ageBuckets;
            return this;
        }

        @Override
        protected MetricsProperties toProperties() {
            double[] quantiles = null;
            double[] quantileErrors = null;
            if (!this.quantiles.isEmpty()) {
                quantiles = new double[this.quantiles.size()];
                quantileErrors = new double[this.quantiles.size()];
                for (int i = 0; i < this.quantiles.size(); ++i) {
                    quantiles[i] = this.quantiles.get((int)i).quantile;
                    quantileErrors[i] = this.quantiles.get((int)i).epsilon;
                }
            }
            MetricsProperties.Builder builder = MetricsProperties.builder();
            if (quantiles != null) {
                builder.summaryQuantiles(quantiles);
            }
            if (quantileErrors != null) {
                builder.summaryQuantileErrors(quantileErrors);
            }
            return builder.exemplarsEnabled(this.exemplarsEnabled).summaryNumberOfAgeBuckets(this.ageBuckets).summaryMaxAgeSeconds(this.maxAgeSeconds).build();
        }

        @Override
        public MetricsProperties getDefaultProperties() {
            return MetricsProperties.builder().exemplarsEnabled(Boolean.valueOf(true)).summaryQuantiles(new double[0]).summaryNumberOfAgeBuckets(Integer.valueOf(5)).summaryMaxAgeSeconds(Long.valueOf(DEFAULT_MAX_AGE_SECONDS)).build();
        }

        @Override
        public Summary build() {
            return new Summary(this, this.properties);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public class DataPoint
    implements DistributionDataPoint {
        private final LongAdder count = new LongAdder();
        private final DoubleAdder sum = new DoubleAdder();
        @Nullable
        private final SlidingWindow<CKMSQuantiles> quantileValues;
        private final Buffer buffer = new Buffer();
        @Nullable
        private final ExemplarSampler exemplarSampler;
        private final long createdTimeMillis = System.currentTimeMillis();

        private DataPoint() {
            if (Summary.this.quantiles.isEmpty()) {
                this.quantileValues = null;
            } else {
                CKMSQuantiles.Quantile[] quantilesArray = Summary.this.quantiles.toArray(new CKMSQuantiles.Quantile[0]);
                this.quantileValues = new SlidingWindow<CKMSQuantiles>(CKMSQuantiles.class, () -> new CKMSQuantiles(quantilesArray), CKMSQuantiles::insert, Summary.this.maxAgeSeconds, Summary.this.ageBuckets);
            }
            this.exemplarSampler = Summary.this.exemplarSamplerConfig != null ? new ExemplarSampler(Summary.this.exemplarSamplerConfig) : null;
        }

        @Override
        public void observe(double value) {
            if (Double.isNaN(value)) {
                return;
            }
            if (!this.buffer.append(value)) {
                this.doObserve(value);
            }
            if (this.exemplarSampler != null) {
                this.exemplarSampler.observe(value);
            }
        }

        @Override
        public void observeWithExemplar(double value, Labels labels) {
            if (Double.isNaN(value)) {
                return;
            }
            if (!this.buffer.append(value)) {
                this.doObserve(value);
            }
            if (this.exemplarSampler != null) {
                this.exemplarSampler.observeWithExemplar(value, labels);
            }
        }

        private void doObserve(double amount) {
            this.sum.add(amount);
            if (this.quantileValues != null) {
                this.quantileValues.observe(amount);
            }
            this.count.increment();
        }

        private SummarySnapshot.SummaryDataPointSnapshot collect(Labels labels) {
            return this.buffer.run(expectedCount -> this.count.sum() == expectedCount.longValue(), () -> new SummarySnapshot.SummaryDataPointSnapshot(this.count.sum(), this.sum.sum(), this.makeQuantiles(), labels, Exemplars.EMPTY, this.createdTimeMillis), this::doObserve);
        }

        private List<CKMSQuantiles.Quantile> getQuantiles() {
            return Summary.this.quantiles;
        }

        private Quantiles makeQuantiles() {
            Quantile[] quantiles = new Quantile[this.getQuantiles().size()];
            for (int i = 0; i < this.getQuantiles().size(); ++i) {
                CKMSQuantiles.Quantile quantile = this.getQuantiles().get(i);
                quantiles[i] = new Quantile(quantile.quantile, Objects.requireNonNull(this.quantileValues).current().get(quantile.quantile));
            }
            return Quantiles.of((Quantile[])quantiles);
        }
    }
}

