/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.OkResult;

public class DeleteFlow
extends AbstractNiFiRegistryCommand<OkResult> {
    public DeleteFlow() {
        super("delete-flow", OkResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes a flow from the registry. If the flow has one or more versions then the force option must be used.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.FLOW_ID.createOption());
        this.addOption(CommandOption.FORCE.createOption());
    }

    @Override
    public OkResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String flowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        boolean forceDelete = properties.containsKey(CommandOption.FORCE.getLongName());
        FlowClient flowClient = client.getFlowClient();
        VersionedFlow versionedFlow = flowClient.get(flowId);
        FlowSnapshotClient flowSnapshotClient = client.getFlowSnapshotClient();
        List snapshotMetadata = flowSnapshotClient.getSnapshotMetadata(flowId);
        if (snapshotMetadata != null && !snapshotMetadata.isEmpty() && !forceDelete) {
            throw new NiFiRegistryException("Flow has versions, use --" + CommandOption.FORCE.getLongName() + " to delete");
        }
        flowClient.delete(versionedFlow.getBucketIdentifier(), versionedFlow.getIdentifier());
        return new OkResult(this.getContext().isInteractive());
    }
}

