/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

public class PGGetParamContext
extends AbstractNiFiCommand<StringResult> {
    public PGGetParamContext() {
        super("pg-get-param-context", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Gets the id of the parameter context that is bound to the given process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        ProcessGroupEntity pgEntity = pgClient.getProcessGroup(pgId);
        String paramContextId = this.getParamContextId(pgEntity.getComponent());
        return new StringResult(paramContextId, this.isInteractive());
    }

    private String getParamContextId(ProcessGroupDTO processGroup) {
        if (processGroup == null) {
            return "";
        }
        ParameterContextReferenceEntity parameterContextReference = processGroup.getParameterContext();
        if (parameterContextReference == null) {
            return "";
        }
        String paramContextId = parameterContextReference.getId();
        if (StringUtils.isBlank((String)paramContextId)) {
            return "";
        }
        return paramContextId;
    }
}

