/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class SubstringAfterEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> afterEvaluator;

    public SubstringAfterEvaluator(Evaluator<String> subject, Evaluator<String> afterEvaluator) {
        this.subject = subject;
        this.afterEvaluator = afterEvaluator;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult("");
        }
        String afterValue = this.afterEvaluator.evaluate(evaluationContext).getValue();
        if (afterValue == null || afterValue.length() == 0) {
            return new StringQueryResult(subjectValue);
        }
        int index = subjectValue.indexOf(afterValue);
        if (index < 0) {
            return new StringQueryResult(subjectValue);
        }
        return new StringQueryResult(subjectValue.substring(index + afterValue.length()));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

