/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
 * for the specific language governing permissions and limitations under the License.
 */
package javax.portlet.faces;

import javax.faces.FacesException;

/**
 * Generic exception thrown when the bridge encounters an unexpected error.  The
 * message returned in this exeception should contain the details of the specific
 * problem.
 */

public class BridgeException extends FacesException
{
  //TODO: This should be regenerated each time this is modified.  Can this be added to maven?
  private static final long serialVersionUID = 6758659847475864393L;

  public BridgeException()
  {
    super();
  }

  public BridgeException(String message)
  {
    super(message);
  }

  public BridgeException(String message, Throwable cause)
  {
    super(message, cause);
  }

  public BridgeException(Throwable cause)
  {
    super(cause);
  }
}
