/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.util.StreamingResourceHandler;
import org.apache.myfaces.component.html.util.StreamingThreadManager;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResource2;
import org.apache.myfaces.renderkit.html.util.MyFacesResourceHandler;
import org.apache.myfaces.renderkit.html.util.ResourceHandler;
import org.apache.myfaces.renderkit.html.util.ResourceLoader;
import org.apache.myfaces.renderkit.html.util.ResourcePosition;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;
import org.apache.myfaces.tomahawk.util.ExternalContextUtils;
import org.apache.myfaces.webapp.filter.PortletUtils;

public class StreamingAddResource
extends AddResource2 {
    private static long REQUEST_ID_COUNTER = 0L;
    private Long requestId;
    private StreamingThreadManager.HeaderInfoEntry headerInfoEntry;
    private Set alreadySeenResources = new TreeSet();
    private static final String PATH_SEPARATOR = "/";
    protected static final Log log = LogFactory.getLog((Class)StreamingAddResource.class);
    protected static final Log logSend = LogFactory.getLog((String)(StreamingAddResource.class.getName() + ".SEND"));
    private static final String RESOURCE_VIRTUAL_PATH = "/faces/myFacesExtensionResource";
    private static final String RESOURCES_CACHE_KEY = AddResource.class.getName() + ".CACHE_KEY";
    protected String _contextPath;
    private String resourceVirtualPath;

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void addJavaScriptHere(FacesContext context, Class myfacesCustomComponent, String resourceName) throws IOException {
        this.addJavaScriptHere(context, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addJavaScriptHere(FacesContext context, String uri) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String src = context.getExternalContext().encodeResourceURL(this.getResourceUri(context, uri));
        writer.writeURIAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    public void addJavaScriptHerePlain(FacesContext context, String uri) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String src = this.getResourceUri(context, uri);
        writer.writeURIAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    public void addJavaScriptHere(FacesContext context, ResourceHandler resourceHandler) throws IOException {
        this.validateResourceHandler(resourceHandler);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String src = context.getExternalContext().encodeResourceURL(this.getResourceUri(context, resourceHandler));
        writer.writeURIAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    public void addResourceHere(FacesContext context, ResourceHandler resourceHandler) throws IOException {
        this.validateResourceHandler(resourceHandler);
        String path = this.getResourceUri(context, resourceHandler);
        ResponseWriter writer = context.getResponseWriter();
        writer.write(context.getExternalContext().encodeResourceURL(path));
    }

    protected void validateResourceHandler(ResourceHandler resourceHandler) {
        if (resourceHandler == null) {
            throw new IllegalArgumentException("ResourceHandler is null");
        }
        this.validateResourceLoader(resourceHandler.getResourceLoaderClass());
    }

    protected void validateResourceLoader(Class resourceloader) {
        if (!ResourceLoader.class.isAssignableFrom(resourceloader)) {
            throw new FacesException("Class " + resourceloader.getName() + " must implement " + ResourceLoader.class.getName());
        }
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler) {
        this.addJavaScriptAtPosition(context, position, resourceHandler, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addJavaScriptAtPositionPlain(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName), false, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName, boolean defer) {
        this.addJavaScriptAtPosition(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName), defer);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, String uri) {
        this.addJavaScriptAtPosition(context, position, uri, false);
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, String uri, boolean defer) {
        WritablePositionedInfo info = (WritablePositionedInfo)this.getScriptInstance(context, uri, defer);
        if (this.checkAlreadyAdded(info)) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            info.writePositionedInfo(response, context.getResponseWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addJavaScriptToBodyTag(FacesContext context, String javascriptEventName, String addedJavaScript) {
        throw new UnsupportedOperationException();
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler, boolean defer) {
        this.addJavaScriptAtPosition(context, position, resourceHandler, defer, false);
    }

    private void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler, boolean defer, boolean encodeURL) {
        this.validateResourceHandler(resourceHandler);
        WritablePositionedInfo info = (WritablePositionedInfo)this.getScriptInstance(context, resourceHandler, defer, encodeURL);
        if (this.checkAlreadyAdded(info)) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            info.writePositionedInfo(response, context.getResponseWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkAlreadyAdded(PositionedInfo info) {
        Long key = new Long(info.hashCode());
        if (this.alreadySeenResources.contains(key)) {
            return true;
        }
        this.alreadySeenResources.add(key);
        return false;
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        this.addStyleSheet(context, position, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, String uri) {
        uri = this.getAbsoluteUri(context, uri);
        this.addStyleSheet(context, this.getStyleInstance(context, uri));
    }

    protected String getAbsoluteUri(FacesContext context, String uri) {
        if (uri.startsWith(PATH_SEPARATOR)) {
            return uri;
        }
        StringBuffer sb = new StringBuffer(80);
        if (context.getExternalContext().getRequestPathInfo() != null) {
            sb.append(context.getExternalContext().getRequestPathInfo());
        }
        sb.append(PATH_SEPARATOR);
        sb.append(uri);
        return sb.toString();
    }

    private void addStyleSheet(FacesContext context, StreamablePositionedInfo styleInstance) {
        if (this.checkAlreadyAdded(styleInstance)) {
            return;
        }
        StreamingThreadManager manager = (StreamingThreadManager)context.getExternalContext().getApplicationMap().get("org.apache.myfaces.component.html.util.StreamingThreadManager");
        this.getHeaderInfoEntry().addInfo(styleInstance);
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler) {
        this.validateResourceHandler(resourceHandler);
        this.addStyleSheet(context, this.getStyleInstance(context, resourceHandler));
    }

    public void addInlineStyleAtPosition(FacesContext context, ResourcePosition position, String inlineStyle) {
        this.addStyleSheet(context, this.getInlineStyleInstance(inlineStyle));
    }

    public void addInlineScriptAtPosition(FacesContext context, ResourcePosition position, String inlineScript) {
        WritablePositionedInfo info = (WritablePositionedInfo)this.getInlineScriptInstance(inlineScript);
        if (this.checkAlreadyAdded(info)) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            info.writePositionedInfo(response, context.getResponseWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getResourceUri(FacesContext context, Class myfacesCustomComponent, String resource, boolean withContextPath) {
        return this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resource), withContextPath);
    }

    public String getResourceUri(FacesContext context, Class myfacesCustomComponent, String resource) {
        return this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resource));
    }

    public String getResourceUri(FacesContext context, ResourceHandler resourceHandler) {
        String uri = resourceHandler.getResourceUri(context);
        if (uri == null) {
            return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), true);
        }
        return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), true) + uri;
    }

    public String getResourceUri(FacesContext context, ResourceHandler resourceHandler, boolean withContextPath) {
        String uri = resourceHandler.getResourceUri(context);
        if (uri == null) {
            return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), withContextPath);
        }
        return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), withContextPath) + uri;
    }

    public String getResourceUri(FacesContext context, String uri) {
        return this.getResourceUri(context, uri, true);
    }

    public String getResourceUri(FacesContext context, String uri, boolean withContextPath) {
        if (withContextPath) {
            return context.getApplication().getViewHandler().getResourceURL(context, uri);
        }
        return uri;
    }

    protected String getResourceUri(FacesContext context, Class resourceLoader, boolean withContextPath) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(MyfacesConfig.getCurrentInstance(context.getExternalContext()).getResourceVirtualPath());
        sb.append(PATH_SEPARATOR);
        sb.append(resourceLoader.getName());
        sb.append(PATH_SEPARATOR);
        sb.append(this.getCacheKey(context));
        sb.append(PATH_SEPARATOR);
        return this.getResourceUri(context, sb.toString(), withContextPath);
    }

    protected long getCacheKey(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        Long cacheKey = (Long)applicationMap.get(RESOURCES_CACHE_KEY);
        if (cacheKey == null) {
            cacheKey = new Long(System.currentTimeMillis() / 100000L);
            applicationMap.put(RESOURCES_CACHE_KEY, cacheKey);
        }
        return cacheKey;
    }

    public boolean isResourceUri(ServletContext servletContext, HttpServletRequest request) {
        String path = this._contextPath != null ? this._contextPath + this.getResourceVirtualPath(servletContext) : this.getResourceVirtualPath(servletContext);
        try {
            if (request.getRequestURI().startsWith(URLEncoder.encode(path, "UTF-8"))) {
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Unsupported encoding UTF-8 used", (Throwable)e);
        }
        return request.getRequestURI().startsWith(path);
    }

    private Class getClass(String className) throws ClassNotFoundException {
        Class clazz = ClassUtils.classForName(className);
        this.validateResourceLoader(clazz);
        return clazz;
    }

    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        String uri = request.getContextPath() + request.getServletPath() + (pathInfo == null ? "" : pathInfo);
        String classNameStartsAfter = this.getResourceVirtualPath(context) + '/';
        int posStartClassName = uri.indexOf(classNameStartsAfter) + classNameStartsAfter.length();
        int posEndClassName = uri.indexOf(PATH_SEPARATOR, posStartClassName);
        String className = uri.substring(posStartClassName, posEndClassName);
        int posEndCacheKey = uri.indexOf(PATH_SEPARATOR, posEndClassName + 1);
        String resourceUri = null;
        if (posEndCacheKey + 1 < uri.length()) {
            resourceUri = uri.substring(posEndCacheKey + 1);
        }
        try {
            Class resourceLoader = this.getClass(className);
            this.validateResourceLoader(resourceLoader);
            ((ResourceLoader)resourceLoader.newInstance()).serveResource(context, request, response, resourceUri);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find class for name: " + className), (Throwable)e);
            this.sendError(response, 404, "Could not find resourceloader class for name: " + className);
        }
        catch (InstantiationException e) {
            log.error((Object)("Could not instantiate class for name: " + className), (Throwable)e);
            this.sendError(response, 500, "Could not instantiate resourceloader class for name: " + className);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Could not access class for name: " + className), (Throwable)e);
            this.sendError(response, 403, "Could not access resourceloader class for name: " + className);
        }
        catch (IOException e) {
            logSend.error((Object)("Error while serving resource: " + resourceUri + ", message : " + e.getMessage()), (Throwable)e);
            this.sendError(response, 500, e.getMessage());
        }
        catch (Throwable e) {
            log.error((Object)("Unknown error while serving resource: " + resourceUri + ", message : " + e.getMessage()), e);
            this.sendError(response, 500, e.getMessage());
        }
    }

    protected void sendError(HttpServletResponse response, int errorCode, String errorText) throws IOException {
        try {
            response.sendError(errorCode, errorText);
        }
        catch (IllegalStateException e) {
            logSend.error((Object)"Could not send error, maybe some data has already been sent.", (Throwable)e);
        }
    }

    public boolean hasHeaderBeginInfos(HttpServletRequest request) {
        throw new UnsupportedOperationException();
    }

    public void parseResponse(HttpServletRequest request, String bufferedResponse, HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public void writeMyFacesJavascriptBeforeBodyEnd(HttpServletRequest request, HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeWithFullHeader(HttpServletRequest request, HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException();
    }

    private StylePositionedInfo getStyleInstance(FacesContext context, ResourceHandler resourceHandler) {
        return new StylePositionedInfo(this.getResourceUri(context, resourceHandler));
    }

    private PositionedInfo getScriptInstance(FacesContext context, ResourceHandler resourceHandler, boolean defer, boolean encodeUrl) {
        return new ScriptPositionedInfo(this.getResourceUri(context, resourceHandler), defer, encodeUrl);
    }

    private StylePositionedInfo getStyleInstance(FacesContext context, String uri) {
        return new StylePositionedInfo(this.getResourceUri(context, uri));
    }

    protected PositionedInfo getScriptInstance(FacesContext context, String uri, boolean defer) {
        return new ScriptPositionedInfo(this.getResourceUri(context, uri), defer);
    }

    private PositionedInfo getInlineScriptInstance(String inlineScript) {
        return new InlineScriptPositionedInfo(inlineScript);
    }

    private InlineStylePositionedInfo getInlineStyleInstance(String inlineStyle) {
        return new InlineStylePositionedInfo(inlineStyle);
    }

    public boolean requiresBuffer() {
        return false;
    }

    protected StreamingThreadManager.HeaderInfoEntry getHeaderInfoEntry() {
        if (this.headerInfoEntry == null) {
            throw new IllegalStateException("responseStarted() needs to be called first");
        }
        return this.headerInfoEntry;
    }

    public void responseStarted() {
    }

    public void responseFinished() {
        this.getHeaderInfoEntry().setRequestDone();
    }

    public void responseStarted(Object context, Object request) {
        if (ExternalContextUtils.getRequestType(context, request).isPortlet()) {
            StreamingThreadManager manager = (StreamingThreadManager)PortletUtils.getAttribute(context, "org.apache.myfaces.component.html.util.StreamingThreadManager");
            this.requestId = manager.putNewHeaderInfoEntry();
            this.headerInfoEntry = manager.getHeaderInfo(this.requestId);
        } else {
            StreamingThreadManager manager = (StreamingThreadManager)((ServletContext)context).getAttribute("org.apache.myfaces.component.html.util.StreamingThreadManager");
            this.requestId = manager.putNewHeaderInfoEntry();
            this.headerInfoEntry = manager.getHeaderInfo(this.requestId);
        }
    }

    public boolean hasHeaderBeginInfos() {
        return false;
    }

    public void addStyleLoaderHere(FacesContext context, Class myfacesCustomComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("link", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("href", (Object)this.getResourceUri(context, new StreamingResourceHandler(this.requestId + "/header.css"), true), null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.endElement("link");
    }

    private String getResourceVirtualPath(ServletContext servletContext) {
        if (this.resourceVirtualPath == null) {
            this.resourceVirtualPath = servletContext.getInitParameter("org.apache.myfaces.RESOURCE_VIRTUAL_PATH");
            if (this.resourceVirtualPath == null) {
                this.resourceVirtualPath = RESOURCE_VIRTUAL_PATH;
            }
        }
        return this.resourceVirtualPath;
    }

    private class InlineStylePositionedInfo
    extends InlinePositionedInfo
    implements StreamablePositionedInfo {
        protected InlineStylePositionedInfo(String inlineStyle) {
            super(inlineStyle);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            writer.startElement("style", null);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.writeText((Object)this.getInlineValue(), null);
            writer.endElement("style");
        }

        public void writePositionedInfo(HttpServletResponse response, PrintWriter writer) throws IOException {
            writer.println();
            writer.write(this.getInlineValue());
            writer.println();
        }
    }

    private class InlineScriptPositionedInfo
    extends InlinePositionedInfo {
        protected InlineScriptPositionedInfo(String inlineScript) {
            super(inlineScript);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeText((Object)this.getInlineValue(), null);
            writer.endElement("script");
        }
    }

    private abstract class InlinePositionedInfo
    implements WritablePositionedInfo {
        private final String _inlineValue;

        protected InlinePositionedInfo(String inlineValue) {
            this._inlineValue = inlineValue;
        }

        public String getInlineValue() {
            return this._inlineValue;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this._inlineValue).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof InlinePositionedInfo) {
                InlinePositionedInfo other = (InlinePositionedInfo)obj;
                return new EqualsBuilder().append((Object)this._inlineValue, (Object)other._inlineValue).isEquals();
            }
            return false;
        }
    }

    private class ScriptPositionedInfo
    extends AbstractResourceUri
    implements WritablePositionedInfo {
        protected final boolean _defer;
        protected final boolean _encodeUrl;

        public ScriptPositionedInfo(String resourceUri, boolean defer) {
            this(resourceUri, defer, true);
        }

        public ScriptPositionedInfo(String resourceUri, boolean defer, boolean encodeUrl) {
            super(resourceUri);
            this._defer = defer;
            this._encodeUrl = encodeUrl;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getResourceUri()).append(this._defer).append(this._encodeUrl).toHashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof ScriptPositionedInfo) {
                ScriptPositionedInfo other = (ScriptPositionedInfo)obj;
                return new EqualsBuilder().append(this._defer, other._defer).append(this._encodeUrl, other._encodeUrl).isEquals();
            }
            return false;
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            if (this._encodeUrl) {
                writer.writeAttribute("src", (Object)response.encodeURL(this.getResourceUri()), null);
            } else {
                writer.writeAttribute("src", (Object)this.getResourceUri(), null);
            }
            if (this._defer) {
                writer.writeAttribute("defer", (Object)"true", null);
            }
            writer.endElement("script");
        }
    }

    private class StylePositionedInfo
    extends AbstractResourceUri
    implements WritablePositionedInfo,
    StreamablePositionedInfo {
        protected StylePositionedInfo(String resourceUri) {
            super(resourceUri);
        }

        public void writePositionedInfo(HttpServletResponse response, ResponseWriter writer) throws IOException {
            writer.startElement("link", null);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("href", (Object)response.encodeURL(this.getResourceUri()), null);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.endElement("link");
        }

        public void writePositionedInfo(HttpServletResponse response, PrintWriter writer) throws IOException {
            writer.println();
            writer.write("@import url(\"");
            writer.write(response.encodeURL(this.getResourceUri()));
            writer.write("\");");
            writer.println();
        }
    }

    private abstract class AbstractResourceUri {
        protected final String _resourceUri;

        protected AbstractResourceUri(String resourceUri) {
            this._resourceUri = resourceUri;
        }

        public int hashCode() {
            return this._resourceUri.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof AbstractResourceUri) {
                AbstractResourceUri other = (AbstractResourceUri)obj;
                return this._resourceUri.equals(other._resourceUri);
            }
            return false;
        }

        protected String getResourceUri() {
            return this._resourceUri;
        }
    }

    protected static interface StreamablePositionedInfo
    extends PositionedInfo {
        public void writePositionedInfo(HttpServletResponse var1, PrintWriter var2) throws IOException;
    }

    protected static interface WritablePositionedInfo
    extends PositionedInfo {
        public void writePositionedInfo(HttpServletResponse var1, ResponseWriter var2) throws IOException;
    }

    protected static interface PositionedInfo {
    }
}

