/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */


package helloDuke;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.el.ELResolver;

import javax.portlet.Event;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.event.EventNavigationResult;

/**
 * <p>This is the main bean for the application.  It maintains a
 * <code>Map</code> of {@link CarBean} instances, keyed by model name,
 * and a <code>Map</code> of {@link CarCustomizer} instances, keyed by
 * package name.  The <code>CarBean</code> instances in the model
 * <code>Map</code> are accessed from several pages, as described
 * below.</p>
 * <p/>
 * <p>Several pages in the application use this bean as the target of
 * method reference and value reference expressions.</p>
 * <p/>
 * <ul>
 * <p/>
 * <li><p>The "chooseLocale" page uses <code>actionListener</code>
 * attributes to point to the {@link #chooseLocaleFromMap} and {@link
 * #chooseLocaleFromLink} methods.</p></li>
 * <p/>
 * <li><p>The "storeFront" page uses value binding expressions to pull
 * information about four of the known car models in the store.</p></li>
 * <p/>
 * <li><p>The "carDetail" page uses value binding expressions to pull
 * information about the currently chosen model.  It also uses the
 * <code>action</code> attribute to convey the user's package
 * choices.</p></li>
 * <p/>
 * <li><p>The "confirmChoices" page uses value binding expressions to
 * pull the user's choices from the currently chosen model.</p></li>
 * <p/>
 * </ul>
 */

public class PortletEventHandler implements BridgeEventHandler {

    private static final Logger LOGGER = Logger.getLogger("helloDuke");


    public PortletEventHandler() {

    }
    
    //
    // Portlet Event Handler
    //
    public EventNavigationResult handleEvent(FacesContext context, Event event)
    {     
      ELResolver facesResolver = context.getELContext().getELResolver();
      UserNameBean userNameBean = (UserNameBean) facesResolver.getValue(context.getELContext(), null, "userNameBean");

      userNameBean.setUserName((String)event.getValue());
      
      // set Navigation result -- by not returning null we allow the result to be mapped by the
      // navigationHandler and hence to have the event not only update state but also navigate.
      // In this case however the current faces-config doesn't contain a navigation rule for
      // this so nothing happens. 
      return null;
    }


}
