/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import org.apache.myfaces.portlet.faces.util.map.PortletAbstractMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestParameterMap
extends PortletAbstractMap<String> {
    private final PortletRequest mPortletRequest;
    private final Map<String, String> mInternalAttributes;
    private Map<String, String[]> mPrivateParameters;

    public PortletRequestParameterMap(Object request, Map<String, String> internal) {
        if (request instanceof PortletRequest) {
            this.mPortletRequest = (PortletRequest)request;
            this.mInternalAttributes = internal == null ? Collections.emptyMap() : new HashMap<String, String>(internal);
        } else {
            throw new IllegalArgumentException("Only supported in a portlet environment");
        }
    }

    @Override
    public String getAttribute(String key) {
        if (this.mPortletRequest != null) {
            String[] params;
            if (this.mPrivateParameters == null) {
                this.mPrivateParameters = this.getPrivateParameterMap();
            }
            if ((params = this.mPrivateParameters.get(key)) != null) {
                return params[0];
            }
            return this.mInternalAttributes.get(key);
        }
        throw new IllegalArgumentException("Only supported in a portlet environment");
    }

    @Override
    public void setAttribute(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAttribute(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.mPortletRequest != null) {
            ArrayList<String> attrNames = new ArrayList<String>(5);
            if (this.mPrivateParameters == null) {
                this.mPrivateParameters = this.getPrivateParameterMap();
            }
            attrNames.addAll(this.mPrivateParameters.keySet());
            attrNames.addAll(this.mInternalAttributes.keySet());
            return Collections.enumeration(attrNames);
        }
        throw new IllegalArgumentException("Only supported in a portlet environment");
    }

    private Map<String, String[]> getPrivateParameterMap() {
        HashMap privateParams = this.mPortletRequest.getPrivateParameterMap();
        if (BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.ACTION_PHASE || BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.RESOURCE_PHASE) {
            Map allParams = this.mPortletRequest.getParameterMap();
            Map publicParams = this.mPortletRequest.getPublicParameterMap();
            if (publicParams.size() == 0) {
                privateParams = allParams;
            } else if (allParams.size() != privateParams.size() + publicParams.size()) {
                privateParams = new HashMap(allParams);
                for (Map.Entry entry : publicParams.entrySet()) {
                    privateParams.remove(entry.getKey());
                }
            }
        }
        return privateParams;
    }
}

