/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf2.impl.scope.conversation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;

public class RedirectedConversationAwareExternalContext
extends ExternalContextWrapper {
    private final ExternalContext wrapped;
    private WindowHandler windowHandler;
    private boolean encodeActionURLs;
    private boolean sessionInvalidated = false;

    public RedirectedConversationAwareExternalContext(ExternalContext wrapped) {
        this.wrapped = wrapped;
    }

    public ExternalContext getWrapped() {
        return this.wrapped;
    }

    public String encodeActionURL(String s) {
        this.lazyInit();
        if (this.encodeActionURLs) {
            String url = this.addWindowIdToUrl(s);
            return this.wrapped.encodeActionURL(url);
        }
        return this.wrapped.encodeActionURL(s);
    }

    public void redirect(String url) throws IOException {
        if (this.sessionInvalidated) {
            this.wrapped.redirect(url);
        } else {
            this.lazyInit();
            ConversationUtils.sendRedirect(this.wrapped, url, this.windowHandler);
        }
    }

    private void lazyInit() {
        if (this.windowHandler == null) {
            this.windowHandler = ConversationUtils.getWindowHandler();
            this.encodeActionURLs = ((WindowContextConfig)CodiUtils.getContextualReferenceByClass(WindowContextConfig.class, (Annotation[])new Annotation[0])).isAddWindowIdToActionUrlsEnabled();
        }
    }

    private String addWindowIdToUrl(String url) {
        return this.windowHandler.encodeURL(url);
    }

    public void invalidateSession() {
        super.invalidateSession();
        this.sessionInvalidated = true;
    }
}

