/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class JndiUtils {
    private static final Logger LOG = Logger.getLogger(JndiUtils.class.getName());
    private static InitialContext initialContext = null;

    private JndiUtils() {
    }

    public static InitialContext getInitialContext() {
        return initialContext;
    }

    public static void bind(String name, Object object) {
        try {
            Context context = initialContext;
            String[] parts = name.split("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                try {
                    context = (Context)initialContext.lookup(parts[i]);
                    continue;
                }
                catch (NameNotFoundException e) {
                    context = initialContext.createSubcontext(parts[i]);
                }
            }
            context.bind(parts[parts.length - 1], object);
        }
        catch (NamingException e) {
            throw new UnhandledException("Could not bind " + name + " to JNDI", (Throwable)e);
        }
    }

    public static void unbind(String name) {
        try {
            initialContext.unbind(name);
        }
        catch (NamingException e) {
            throw new UnhandledException("Could not unbind " + name + " from JNDI", (Throwable)e);
        }
    }

    public static <T> T lookup(String name, Class<? extends T> expectedClass) {
        try {
            block11: {
                Object lookedUp = initialContext.lookup(name);
                if (lookedUp != null) {
                    if (expectedClass.isAssignableFrom(lookedUp.getClass())) {
                        return (T)lookedUp;
                    }
                    if (lookedUp instanceof String) {
                        try {
                            Class<?> lookedUpClass = Class.forName((String)lookedUp);
                            if (expectedClass.isAssignableFrom(lookedUpClass)) {
                                try {
                                    return (T)lookedUpClass.newInstance();
                                }
                                catch (Exception e) {
                                    LOG.log(Level.SEVERE, "Class " + lookedUpClass + " from JNDI lookup for name " + name + " could not be instantiated", e);
                                    break block11;
                                }
                            }
                            LOG.log(Level.SEVERE, "JNDI lookup for key " + name + " returned class " + lookedUpClass.getName() + " which does not implement/extend the expected class" + expectedClass.getName());
                        }
                        catch (ClassNotFoundException cnfe) {
                            LOG.log(Level.SEVERE, "Could not find Class " + lookedUp + " from JNDI lookup for name " + name, cnfe);
                        }
                    } else {
                        LOG.log(Level.SEVERE, "JNDI lookup for key " + name + " should return a value of " + expectedClass + ", but returned " + lookedUp);
                    }
                }
            }
            return null;
        }
        catch (NamingException e) {
            throw new UnhandledException("Could not get " + name + " from JNDI", (Throwable)e);
        }
    }

    static {
        try {
            initialContext = new InitialContext();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

