/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class ConfigUtils {
    private static final String BASE_NAME = "org.apache.myfaces.extensions.cdi.";
    private static final String FILE_NAME = "myfaces-extcdi";
    private static Map<ClassLoader, Map<String, String>> propertyCache = new ConcurrentHashMap<ClassLoader, Map<String, String>>();

    private ConfigUtils() {
    }

    public static List<String> getConfiguredValue(String key) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> cache = ConfigUtils.getPropertyCache();
        String configKey = key;
        int endOfPrefixIndex = key.indexOf(".");
        if (endOfPrefixIndex > -1) {
            configKey = key.substring(endOfPrefixIndex + 1);
        } else {
            endOfPrefixIndex = 0;
        }
        String configuredValue = cache.get(key);
        if (configuredValue == null) {
            configuredValue = cache.get(configKey);
        }
        if ("".equals(configuredValue)) {
            return Collections.emptyList();
        }
        if (configuredValue != null) {
            result.add(configuredValue);
        } else {
            String bundleName;
            if (key.contains("@") && key.lastIndexOf("@") < endOfPrefixIndex) {
                bundleName = key.substring(0, key.indexOf("."));
                bundleName = bundleName.replace("@", ".");
            } else {
                bundleName = BASE_NAME + key.substring(0, endOfPrefixIndex);
            }
            try {
                Properties properties;
                ResourceBundle resourceBundle;
                try {
                    resourceBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), ClassUtils.getClassLoader(null));
                }
                catch (MissingResourceException e) {
                    try {
                        resourceBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), ConfigUtils.class.getClassLoader());
                    }
                    catch (MissingResourceException e2) {
                        resourceBundle = null;
                    }
                }
                if (resourceBundle == null) {
                    try {
                        resourceBundle = ResourceBundle.getBundle(FILE_NAME);
                    }
                    catch (MissingResourceException e2) {
                        try {
                            resourceBundle = ResourceBundle.getBundle(FILE_NAME, Locale.getDefault(), ConfigUtils.class.getClassLoader());
                        }
                        catch (MissingResourceException e3) {
                            resourceBundle = null;
                        }
                    }
                }
                if (resourceBundle != null) {
                    try {
                        configuredValue = resourceBundle.getString(configKey);
                        result.add(configuredValue);
                        cache.put(configKey, configuredValue);
                    }
                    catch (MissingResourceException e) {
                        resourceBundle = null;
                    }
                }
                if (resourceBundle == null && (properties = ConfigUtils.getProperties("META-INF/myfaces-extcdi.properties")) != null) {
                    configuredValue = properties.getProperty(configKey);
                    result.add(configuredValue);
                    cache.put(configKey, configuredValue);
                }
                if (configuredValue == null) {
                    cache.put(configKey, "");
                    return Collections.emptyList();
                }
            }
            catch (Exception e) {
                cache.put(configKey, "");
                return Collections.emptyList();
            }
        }
        return result;
    }

    private static Map<String, String> getPropertyCache() {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        Map<String, String> cache = propertyCache.get(classLoader);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, String>();
            propertyCache.put(classLoader, cache);
        }
        return cache;
    }

    public static Properties getProperties(String resourceName) {
        Properties properties = null;
        ClassLoader classLoader = ClassUtils.getClassLoader(resourceName);
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        if (inputStream == null) {
            inputStream = ClassUtils.class.getClassLoader().getResourceAsStream(resourceName);
        }
        if (inputStream != null) {
            properties = new Properties();
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                return null;
            }
        }
        return properties;
    }
}

