/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.config.view;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.Advanced;
import org.apache.myfaces.extensions.cdi.core.api.InvocationOrder;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowContext;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PageBeanDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.JsfPhaseListener;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.LifecycleAwarePageBeanDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.RequestLifecycleCallbackEntry;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.WindowContextManagerObserver;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Advanced
@JsfPhaseListener
@InvocationOrder(value=2000)
public final class PhasesLifecycleCallbackPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 6893021853444122202L;
    private static final String INITIALIZED_VIEW_ID_MARKER_KEY = PhasesLifecycleCallbackPhaseListener.class.getName();
    @Inject
    private WindowContext windowContext;
    @Inject
    private BeanManager beanManager;

    public void afterPhase(PhaseEvent event) {
        this.processInitView(event);
        this.processPostRenderView(event);
        this.processPhaseCallbacks(event, false);
    }

    public void beforePhase(PhaseEvent event) {
        this.processInitView(event);
        this.processPreRenderView(event);
        this.processPhaseCallbacks(event, true);
    }

    private void processInitView(PhaseEvent event) {
        if (event.getPhaseId().equals(PhaseId.RESTORE_VIEW) && !this.isRedirectRequest(event.getFacesContext())) {
            return;
        }
        if (Boolean.TRUE.equals(event.getFacesContext().getExternalContext().getRequestMap().get(WindowContextManagerObserver.INITIAL_REDIRCT_PERFORMED_KEY))) {
            return;
        }
        if (this.isValidView(event.getFacesContext())) {
            this.processInitView(event.getFacesContext().getViewRoot().getViewId());
        }
    }

    private void processInitView(String viewId) {
        if (viewId.equals(this.windowContext.getAttribute(INITIALIZED_VIEW_ID_MARKER_KEY, String.class))) {
            return;
        }
        this.windowContext.setAttribute(INITIALIZED_VIEW_ID_MARKER_KEY, (Object)viewId);
        ViewConfigDescriptor viewDefinitionEntry = ViewConfigCache.getViewConfigDescriptor(viewId);
        if (viewDefinitionEntry instanceof EditableViewConfigDescriptor) {
            ((EditableViewConfigDescriptor)viewDefinitionEntry).invokeInitViewMethods();
        }
    }

    private void processPreRenderView(PhaseEvent event) {
        UIViewRoot uiViewRoot = event.getFacesContext().getViewRoot();
        if (event.getPhaseId().equals(PhaseId.RENDER_RESPONSE) && uiViewRoot != null) {
            this.processPreRenderView(uiViewRoot.getViewId());
        }
    }

    private void processPostRenderView(PhaseEvent event) {
        UIViewRoot uiViewRoot = event.getFacesContext().getViewRoot();
        if (event.getPhaseId().equals(PhaseId.RENDER_RESPONSE) && uiViewRoot != null) {
            this.processPostRenderView(uiViewRoot.getViewId());
        }
    }

    private void processPreRenderView(String viewId) {
        ViewConfigDescriptor viewDefinitionEntry = ViewConfigCache.getViewConfigDescriptor(viewId);
        if (viewDefinitionEntry instanceof EditableViewConfigDescriptor) {
            ((EditableViewConfigDescriptor)viewDefinitionEntry).invokePreRenderViewMethods();
        }
    }

    private void processPostRenderView(String viewId) {
        ViewConfigDescriptor viewDefinitionEntry = ViewConfigCache.getViewConfigDescriptor(viewId);
        if (viewDefinitionEntry instanceof EditableViewConfigDescriptor) {
            ((EditableViewConfigDescriptor)viewDefinitionEntry).invokePostRenderViewMethods();
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private void processPhaseCallbacks(PhaseEvent phaseEvent, boolean beforePhase) {
        UIViewRoot viewRoot = phaseEvent.getFacesContext().getViewRoot();
        if (viewRoot == null) {
            return;
        }
        String viewId = viewRoot.getViewId();
        ViewConfigDescriptor viewDefinitionEntry = ViewConfigCache.getViewConfigDescriptor(viewId);
        if (viewDefinitionEntry == null) {
            return;
        }
        List beanEntries = viewDefinitionEntry.getPageBeanDescriptors();
        for (PageBeanDescriptor beanEntry : beanEntries) {
            List<Method> lifecycleCallbacks;
            RequestLifecycleCallbackEntry phasesLifecycleCallbackEntry;
            if (!(beanEntry instanceof LifecycleAwarePageBeanDescriptor) || (phasesLifecycleCallbackEntry = ((LifecycleAwarePageBeanDescriptor)beanEntry).getPhasesLifecycleCallback(phaseEvent.getPhaseId())) == null || (lifecycleCallbacks = beforePhase ? phasesLifecycleCallbackEntry.getBeforePhaseCallbacks() : phasesLifecycleCallbackEntry.getAfterPhaseCallbacks()).isEmpty()) continue;
            Object bean = CodiUtils.getContextualReferenceByName((BeanManager)this.beanManager, (String)beanEntry.getBeanName(), Object.class);
            this.invokePhasesLifecycleCallbacks(bean, lifecycleCallbacks, phaseEvent);
        }
    }

    private void invokePhasesLifecycleCallbacks(Object bean, List<Method> lifecycleCallbacks, PhaseEvent phaseEvent) {
        try {
            for (Method currentMethod : lifecycleCallbacks) {
                currentMethod.setAccessible(true);
                Class<?>[] parameterTypes = currentMethod.getParameterTypes();
                if (parameterTypes.length == 0) {
                    currentMethod.invoke(bean, new Object[0]);
                    continue;
                }
                if (parameterTypes.length == 1 && PhaseEvent.class.isAssignableFrom(parameterTypes[0])) {
                    currentMethod.invoke(bean, phaseEvent);
                    continue;
                }
                throw ExceptionUtils.invalidPhasesCallbackMethod(bean.getClass(), currentMethod);
            }
        }
        catch (IllegalAccessException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private boolean isValidView(FacesContext facesContext) {
        return facesContext.getViewRoot() != null && facesContext.getViewRoot().getViewId() != null;
    }

    private boolean isRedirectRequest(FacesContext facesContext) {
        return facesContext.getResponseComplete();
    }
}

