/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.apache.myfaces.view.facelets.compiler.Instruction;

final class LiteralXMLInstruction
implements Instruction {
    private static final char[] STOP = new char[0];
    private final char[] instruction;
    private final int len;

    public LiteralXMLInstruction(String literal) {
        this.instruction = literal.toCharArray();
        this.len = this.instruction.length;
    }

    @Override
    public void write(FacesContext context) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.writeText(STOP, 0, 0);
        rw.write(this.instruction, 0, this.len);
    }

    @Override
    public Instruction apply(ExpressionFactory factory, ELContext ctx) {
        return this;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }
}

