/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.view.ViewScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.cdi.WebsocketChannel;
import org.apache.myfaces.push.cdi.WebsocketChannelMetadata;
import org.apache.myfaces.push.cdi.WebsocketSessionManager;

@ApplicationScoped
public class WebsocketScopeManager {
    public static final String SCOPE_APPLICATION = "application";
    public static final String SCOPE_SESSION = "session";
    public static final String SCOPE_VIEW = "view";
    @Inject
    private BeanManager beanManager;

    public AbstractScope getScope(String scope, boolean create) {
        if (SCOPE_APPLICATION.equals(scope)) {
            return this.getApplicationScope(create);
        }
        if (SCOPE_SESSION.equals(scope)) {
            return this.getSessionScope(create);
        }
        if (SCOPE_VIEW.equals(scope)) {
            return this.getViewScope(create);
        }
        throw new UnsupportedOperationException("Scope '" + scope + "' not supported!");
    }

    public ApplicationScope getApplicationScope(boolean create) {
        return CDIUtils.get(this.beanManager, ApplicationScope.class, create, new Annotation[0]);
    }

    public SessionScope getSessionScope(boolean create) {
        return CDIUtils.get(this.beanManager, SessionScope.class, create, new Annotation[0]);
    }

    public ViewScope getViewScope(boolean create) {
        return CDIUtils.get(this.beanManager, ViewScope.class, create, new Annotation[0]);
    }

    @ApplicationScoped
    public static class ApplicationScope
    extends AbstractScope {
    }

    @SessionScoped
    public static class SessionScope
    extends AbstractUserScope
    implements Serializable {
        @Inject
        private WebsocketSessionManager sessionManager;

        @PreDestroy
        public void destroy() {
            for (Map.Entry entry : this.tokens.entrySet()) {
                if (!WebsocketScopeManager.SCOPE_SESSION.equals(((WebsocketChannelMetadata)entry.getValue()).getScope())) continue;
                this.sessionManager.removeChannelToken((String)entry.getKey());
            }
            this.channelTokens.clear();
            this.tokens.clear();
        }

        public void destroyChannelToken(String channelToken) {
            String channel = null;
            for (Map.Entry entry : this.channelTokens.entrySet()) {
                Iterator it = ((List)entry.getValue()).iterator();
                while (it.hasNext()) {
                    WebsocketChannel wschannel = (WebsocketChannel)it.next();
                    if (!channelToken.equals(wschannel.getChannelToken())) continue;
                    it.remove();
                    break;
                }
                if (!((List)entry.getValue()).isEmpty()) continue;
                channel = (String)entry.getKey();
            }
            if (channel != null) {
                this.channelTokens.remove(channel);
            }
            this.tokens.remove(channelToken);
        }
    }

    @ViewScoped
    public static class ViewScope
    extends AbstractUserScope
    implements Serializable {
        @Inject
        private WebsocketScopeManager scopeManager;
        @Inject
        private WebsocketSessionManager sessionManager;

        @PreDestroy
        public void destroy() {
            SessionScope sessionScope = (SessionScope)this.scopeManager.getScope(WebsocketScopeManager.SCOPE_SESSION, false);
            if (sessionScope != null) {
                for (String token : this.tokens.keySet()) {
                    sessionScope.destroyChannelToken(token);
                }
            }
            this.channelTokens.clear();
            this.tokens.clear();
        }
    }

    public static abstract class AbstractUserScope
    extends AbstractScope {
        protected Map<String, WebsocketChannelMetadata> tokens = new ConcurrentHashMap<String, WebsocketChannelMetadata>(2, 1.0f);

        public void registerToken(String token, WebsocketChannelMetadata metadata) {
            this.tokens.put(token, metadata);
        }

        public String getChannelToken(WebsocketChannelMetadata metadata) {
            if (!metadata.isConnected()) {
                return null;
            }
            String token = null;
            for (Map.Entry<String, WebsocketChannelMetadata> entry : this.tokens.entrySet()) {
                if (!metadata.equals(entry.getValue())) continue;
                token = entry.getKey();
                break;
            }
            return token;
        }

        public boolean isTokenValid(String token) {
            return this.tokens.containsKey(token);
        }

        public Serializable getUserFromChannelToken(String channelToken) {
            WebsocketChannelMetadata metadata;
            if (this.tokens != null && (metadata = this.tokens.get(channelToken)) != null) {
                return metadata.getUser();
            }
            return null;
        }
    }

    public static abstract class AbstractScope
    implements Serializable {
        protected Map<String, List<WebsocketChannel>> channelTokens = new ConcurrentHashMap<String, List<WebsocketChannel>>(2, 1.0f);

        public void registerWebsocketSession(String token, WebsocketChannelMetadata metadata) {
            this.channelTokens.putIfAbsent(metadata.getChannel(), new ArrayList(1));
            this.channelTokens.get(metadata.getChannel()).add(new WebsocketChannel(token, metadata));
        }

        public boolean isChannelAvailable(String channel) {
            return this.channelTokens.containsKey(channel);
        }

        public List<String> getChannelTokens(String channel) {
            List<WebsocketChannel> list = this.channelTokens.get(channel);
            if (list != null && !list.isEmpty()) {
                ArrayList<String> value = new ArrayList<String>(list.size());
                for (WebsocketChannel md : list) {
                    value.add(md.getChannelToken());
                }
                return value;
            }
            return Collections.emptyList();
        }

        public <S extends Serializable> List<String> getChannelTokens(String channel, S user) {
            List<WebsocketChannel> list = this.channelTokens.get(channel);
            if (list != null && !list.isEmpty()) {
                ArrayList<String> value = new ArrayList<String>(list.size());
                for (WebsocketChannel md : list) {
                    if (!user.equals(md.getUser())) continue;
                    value.add(md.getChannelToken());
                }
                return value;
            }
            return null;
        }
    }
}

