/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.config;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.faces.annotation.FacesConfig;
import org.apache.myfaces.cdi.config.FacesConfigBeanHolder;
import org.apache.myfaces.cdi.util.CDIUtils;

public class FacesConfigExtension
implements Extension {
    private FacesConfig facesConfig;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType<FacesConfigBeanHolder> beanHolder = beanManager.createAnnotatedType(FacesConfigBeanHolder.class);
        event.addAnnotatedType(beanHolder, beanHolder.getJavaClass().getName());
    }

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        if (event.getAnnotatedBeanClass().isAnnotationPresent(FacesConfig.class)) {
            AnnotatedType<FacesConfig> annotated = event.getAnnotatedBeanClass();
            this.facesConfig = annotated.getAnnotation(FacesConfig.class);
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
        FacesConfigBeanHolder holder = CDIUtils.get(beanManager, FacesConfigBeanHolder.class);
        holder.setFacesConfig(this.facesConfig);
    }
}

