/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UIOutput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;

public class HtmlHiddenRenderer
extends HtmlRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIInput.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        String clientId = uiComponent.getClientId(facesContext);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String value = RendererUtils.getStringValue(facesContext, uiComponent);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, "value");
        }
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)uiComponent, submittedValue);
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (!(component instanceof UIInput)) {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
        HtmlRendererUtils.decodeUIInput(facesContext, component);
    }
}

