/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import jakarta.faces.context.ExternalContext;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.apache.myfaces.util.lang.ClassUtils;

public final class ExternalContextUtils {
    private static final Class<?> PORTLET_CONTEXT_CLASS = ClassUtils.simpleClassForName((String)"javax.portlet.PortletContext", (boolean)false);
    private static final String PORTLET_LIFECYCLE_PHASE = "javax.portlet.faces.phase";

    public static boolean isPortlet(ExternalContext ec) {
        if (PORTLET_CONTEXT_CLASS == null) {
            return false;
        }
        if (PORTLET_CONTEXT_CLASS.isInstance(ec.getContext())) {
            return true;
        }
        Map requestMap = ec.getRequestMap();
        return requestMap.containsKey(PORTLET_LIFECYCLE_PHASE);
    }

    public static boolean isHttpServletRequest(ExternalContext ec) {
        return !ExternalContextUtils.isPortlet(ec) && ec.getRequest() instanceof HttpServletRequest;
    }

    public static HttpServletResponse getHttpServletResponse(ExternalContext ec) {
        if (ExternalContextUtils.isHttpServletRequest(ec)) {
            return (HttpServletResponse)ec.getResponse();
        }
        return null;
    }

    public static HttpServletResponse getHttpServletResponse(Object response) {
        if (response != null) {
            if (response instanceof HttpServletResponse) {
                return (HttpServletResponse)response;
            }
            if (response instanceof ServletResponseWrapper) {
                response = ((ServletResponseWrapper)response).getResponse();
            }
        }
        return null;
    }

    private ExternalContextUtils() {
    }
}

