/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.application.FacesServletMapping;
import org.apache.myfaces.application.FacesServletMappingUtils;
import org.apache.myfaces.application.InvalidViewIdException;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.util.ExternalContextUtils;
import org.apache.myfaces.util.UrlPatternMatcher;
import org.apache.myfaces.util.lang.ConcurrentLRUCache;
import org.apache.myfaces.util.lang.StringUtils;

public class ViewIdSupport {
    private static final String INSTANCE_KEY = ViewIdSupport.class.getName();
    private static final String JAKARTA_SERVLET_INCLUDE_SERVLET_PATH = "jakarta.servlet.include.servlet_path";
    private static final String JAKARTA_SERVLET_INCLUDE_PATH_INFO = "jakarta.servlet.include.path_info";
    private static final Logger log = Logger.getLogger(ViewIdSupport.class.getName());
    private static final String VIEW_HANDLER_SUPPORT_SB = "oam.viewhandler.SUPPORT_SB";
    private MyfacesConfig config;
    private volatile ConcurrentLRUCache<String, Boolean> viewIdExistsCache;
    private volatile ConcurrentLRUCache<String, String> viewIdDeriveCache;
    private volatile ConcurrentLRUCache<String, Boolean> viewIdProtectedCache;

    public static ViewIdSupport getInstance(FacesContext facesContext) {
        ViewIdSupport viewIdSupport = (ViewIdSupport)facesContext.getExternalContext().getApplicationMap().get(INSTANCE_KEY);
        if (viewIdSupport == null) {
            viewIdSupport = new ViewIdSupport(facesContext);
            facesContext.getExternalContext().getApplicationMap().put(INSTANCE_KEY, viewIdSupport);
        }
        return viewIdSupport;
    }

    protected ViewIdSupport(FacesContext facesContext) {
        this.config = MyfacesConfig.getCurrentInstance(facesContext);
        int viewIdCacheSize = this.config.getViewIdCacheSize();
        if (this.config.isViewIdExistsCacheEnabled()) {
            this.viewIdExistsCache = new ConcurrentLRUCache((viewIdCacheSize * 4 + 3) / 3, viewIdCacheSize);
        }
        if (this.config.isViewIdDeriveCacheEnabled()) {
            this.viewIdDeriveCache = new ConcurrentLRUCache((viewIdCacheSize * 4 + 3) / 3, viewIdCacheSize);
        }
        if (this.config.isViewIdProtectedCacheEnabled()) {
            this.viewIdProtectedCache = new ConcurrentLRUCache((viewIdCacheSize * 4 + 3) / 3, viewIdCacheSize);
        }
    }

    public String deriveLogicalViewId(FacesContext context, String rawViewId) {
        return this.deriveViewId(context, rawViewId, false);
    }

    public String deriveViewId(FacesContext context, String viewId) {
        return this.deriveViewId(context, viewId, true);
    }

    protected String deriveViewId(FacesContext context, String rawViewId, boolean checkViewExists) {
        if (rawViewId == null) {
            return null;
        }
        String viewId = null;
        if (this.viewIdDeriveCache != null) {
            viewId = this.viewIdDeriveCache.get(rawViewId);
        }
        if (viewId == null) {
            FacesServletMapping mapping = FacesServletMappingUtils.getCurrentRequestFacesServletMapping(context);
            if (mapping == null || mapping.isExtensionMapping()) {
                viewId = this.handleSuffixMapping(context, rawViewId);
            } else if (mapping.isExactMapping()) {
                viewId = rawViewId.equals(mapping.getExact()) ? this.handleSuffixMapping(context, rawViewId + ".jsf") : rawViewId;
            } else if (mapping.isPrefixMapping()) {
                viewId = this.handlePrefixMapping(rawViewId, mapping.getPrefix());
                if (viewId != null && viewId.equals(mapping.getPrefix()) && !ExternalContextUtils.isPortlet(context.getExternalContext())) {
                    throw new InvalidViewIdException();
                }
                if (viewId != null && viewId.equals(mapping.getPrefix())) {
                    viewId = this.handleSuffixMapping(context, viewId + ".jsf");
                }
            } else if (mapping.getUrlPattern().startsWith(rawViewId)) {
                throw new InvalidViewIdException(rawViewId);
            }
            if (viewId != null && this.viewIdDeriveCache != null) {
                this.viewIdDeriveCache.put(rawViewId, viewId);
            }
        }
        if (viewId != null && checkViewExists) {
            return this.isViewExistent(context, viewId) ? viewId : null;
        }
        return viewId;
    }

    public String calculateActionURL(FacesContext context, String viewId) {
        String exactMappingViewId;
        if (viewId == null || !viewId.startsWith("/")) {
            throw new IllegalArgumentException("ViewId must start with a '/': " + viewId);
        }
        FacesServletMapping mapping = FacesServletMappingUtils.getCurrentRequestFacesServletMapping(context);
        ExternalContext externalContext = context.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        StringBuilder builder = SharedStringBuilder.get((FacesContext)context, (String)VIEW_HANDLER_SUPPORT_SB);
        if (contextPath != null && (contextPath.length() != 1 || contextPath.charAt(0) != '/')) {
            builder.append(contextPath);
        }
        if (mapping != null && mapping.isExactMapping() && (exactMappingViewId = this.calculateExactMapping(context, viewId)) != null && !exactMappingViewId.isEmpty() && !mapping.getExact().equals(exactMappingViewId) && (mapping = FacesServletMappingUtils.getExactMapping(context, exactMappingViewId)) == null && (mapping = FacesServletMappingUtils.getGenericPrefixOrSuffixMapping(context)) == null) {
            throw new IllegalStateException("No generic (either prefix or suffix) servlet-mapping found for FacesServlet.This is required serve views, that are not exact mapped.");
        }
        if (mapping != null) {
            if (mapping.isExactMapping()) {
                builder.append(mapping.getExact());
            } else if (mapping.isExtensionMapping()) {
                boolean founded = false;
                for (String contextSuffix : this.config.getViewSuffix()) {
                    if (!viewId.endsWith(contextSuffix)) continue;
                    builder.append(viewId.substring(0, viewId.indexOf(contextSuffix)));
                    builder.append(mapping.getExtension());
                    founded = true;
                    break;
                }
                if (!founded) {
                    if (viewId.endsWith(mapping.getExtension())) {
                        builder.append(viewId);
                    } else if (viewId.lastIndexOf(46) != -1) {
                        builder.append(viewId.substring(0, viewId.lastIndexOf(46)));
                        builder.append(this.config.getViewSuffix()[0]);
                    } else {
                        builder.append(viewId);
                        builder.append(this.config.getViewSuffix()[0]);
                    }
                }
            } else if (mapping.isPrefixMapping()) {
                builder.append(mapping.getPrefix());
                builder.append(viewId);
            }
        } else {
            builder.append(viewId);
        }
        if (this.isViewProtected(context, viewId)) {
            int index = builder.indexOf("?");
            if (index >= 0) {
                builder.append('&');
            } else {
                builder.append('?');
            }
            builder.append("jakarta.faces.Token");
            builder.append('=');
            ResponseStateManager rsm = context.getRenderKit().getResponseStateManager();
            builder.append(rsm.getCryptographicallyStrongTokenFromSession(context));
        }
        String calculatedActionURL = builder.toString();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Calculated actionURL: '" + calculatedActionURL + "' for viewId: '" + viewId + "'");
        }
        return calculatedActionURL;
    }

    private String calculateExactMapping(FacesContext context, String viewId) {
        String prefixedExactMapping = null;
        for (String contextSuffix : this.config.getViewSuffix()) {
            if (!viewId.endsWith(contextSuffix)) continue;
            prefixedExactMapping = viewId.substring(0, viewId.length() - contextSuffix.length());
            break;
        }
        return prefixedExactMapping == null ? viewId : prefixedExactMapping;
    }

    protected String handlePrefixMapping(String viewId, String prefix) {
        prefix = StringUtils.isBlank((String)prefix) ? "//" : (String)prefix + "/";
        String uri = viewId;
        while (uri.startsWith((String)prefix) || uri.startsWith("//")) {
            if (uri.startsWith((String)prefix)) {
                uri = uri.substring(((String)prefix).length() - 1);
                continue;
            }
            uri = uri.substring(1);
        }
        return uri;
    }

    protected String handleSuffixMapping(FacesContext context, String requestViewId) {
        int slashPos = requestViewId.lastIndexOf(47);
        int extensionPos = requestViewId.lastIndexOf(46);
        StringBuilder builder = SharedStringBuilder.get((FacesContext)context, (String)VIEW_HANDLER_SUPPORT_SB);
        for (String defaultSuffix : this.config.getViewSuffix()) {
            builder.setLength(0);
            builder.append(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (this.config.getFaceletsViewMappings() != null && this.config.getFaceletsViewMappings().length > 0) {
                for (String mapping : this.config.getFaceletsViewMappings()) {
                    if (mapping.startsWith("/")) continue;
                    if (mapping.equals(candidateViewId)) {
                        return candidateViewId;
                    }
                    if (!mapping.startsWith(".")) continue;
                    builder.setLength(0);
                    builder.append(candidateViewId);
                    builder.replace(candidateViewId.lastIndexOf(46), candidateViewId.length(), mapping);
                    String tempViewId = builder.toString();
                    if (!this.isViewExistent(context, tempViewId)) continue;
                    return tempViewId;
                }
            }
            if (!this.isViewExistent(context, candidateViewId)) continue;
            return candidateViewId;
        }
        String faceletsDefaultSuffix = this.config.getFaceletsViewSuffix();
        if (faceletsDefaultSuffix != null) {
            for (String defaultSuffix : this.config.getViewSuffix()) {
                if (!faceletsDefaultSuffix.equals(defaultSuffix)) continue;
                faceletsDefaultSuffix = null;
                break;
            }
        }
        if (faceletsDefaultSuffix != null) {
            builder.setLength(0);
            builder.append(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), faceletsDefaultSuffix);
            } else {
                builder.append(faceletsDefaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (this.isViewExistent(context, candidateViewId)) {
                return candidateViewId;
            }
        }
        if (this.isViewExistent(context, requestViewId)) {
            return requestViewId;
        }
        return null;
    }

    public boolean isViewExistent(FacesContext facesContext, String viewId) {
        try {
            Boolean resourceExists = null;
            if (this.viewIdExistsCache != null) {
                resourceExists = this.viewIdExistsCache.get(viewId);
            }
            if (resourceExists == null) {
                ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
                resourceExists = vdl != null ? Boolean.valueOf(vdl.viewExists(facesContext, viewId)) : Boolean.valueOf(facesContext.getExternalContext().getResource(viewId) != null);
                if (this.viewIdExistsCache != null) {
                    this.viewIdExistsCache.put(viewId, resourceExists);
                }
            }
            return resourceExists;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public String calculateViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        boolean traceEnabled = log.isLoggable(Level.FINEST);
        String viewId = null;
        if (ExternalContextUtils.isPortlet(externalContext)) {
            viewId = externalContext.getRequestPathInfo();
        } else {
            viewId = (String)requestMap.get(JAKARTA_SERVLET_INCLUDE_PATH_INFO);
            if (viewId != null) {
                if (traceEnabled) {
                    log.finest("Calculated viewId '" + viewId + "' from request param 'jakarta.servlet.include.path_info'");
                }
            } else {
                viewId = externalContext.getRequestPathInfo();
                if (viewId != null && traceEnabled) {
                    log.finest("Calculated viewId '" + viewId + "' from request path info");
                }
            }
            if (viewId == null && (viewId = (String)requestMap.get(JAKARTA_SERVLET_INCLUDE_SERVLET_PATH)) != null && traceEnabled) {
                log.finest("Calculated viewId '" + viewId + "' from request param 'jakarta.servlet.include.servlet_path'");
            }
        }
        if (viewId == null && (viewId = externalContext.getRequestServletPath()) != null && traceEnabled) {
            log.finest("Calculated viewId '" + viewId + "' from request servlet path");
        }
        if (viewId == null) {
            throw new FacesException("Could not determine view id.");
        }
        return viewId;
    }

    public boolean isViewProtected(FacesContext context, String viewId) {
        if (viewId == null) {
            return false;
        }
        Boolean protectedView = null;
        if (this.viewIdProtectedCache != null) {
            protectedView = this.viewIdProtectedCache.get(viewId);
        }
        if (protectedView == null) {
            protectedView = false;
            Set protectedViews = context.getApplication().getViewHandler().getProtectedViewsUnmodifiable();
            if (!protectedViews.isEmpty()) {
                for (String urlPattern : protectedViews) {
                    if (!UrlPatternMatcher.match(viewId, urlPattern)) continue;
                    protectedView = true;
                    break;
                }
            }
            if (this.viewIdProtectedCache != null) {
                this.viewIdProtectedCache.put(viewId, protectedView);
            }
        }
        return protectedView;
    }
}

